/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.supplier;

import java.util.Arrays;
import java.util.List;
import org.kuali.common.jdbc.SqlMetaData;
import org.kuali.common.jdbc.supplier.AbstractSupplier;
import org.springframework.util.Assert;

public class SimpleStringSupplier
extends AbstractSupplier {
    List<String> strings;
    boolean closed = true;

    public SimpleStringSupplier() {
        this((String)null);
    }

    public SimpleStringSupplier(String sql) {
        this(Arrays.asList(sql));
    }

    public SimpleStringSupplier(List<String> strings) {
        this.strings = strings;
    }

    @Override
    public void open() {
        Assert.notNull(this.strings, (String)"strings is null");
        Assert.isTrue((boolean)this.closed, (String)"closed is true");
        this.closed = false;
    }

    @Override
    public List<String> getSql() {
        if (this.closed) {
            return null;
        }
        this.closed = true;
        return this.strings;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void fillInMetaData() {
        int count = this.strings.size();
        long size = 0L;
        for (String string : this.strings) {
            size += (long)string.length();
        }
        this.metaData = new SqlMetaData(count, size);
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public void setStrings(List<String> strings) {
        this.strings = strings;
    }
}

