/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.guice;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.kuali.common.jute.base.Exceptions;
import org.kuali.common.jute.base.Optionals;
import org.kuali.maven.plugins.guice.MavenModule;

@Mojo(name="run", threadSafe=true)
@Execute(goal="run")
public class GuiceMojo
extends AbstractMojo {
    static final String RUN = "run";
    private static final String MODULE = "Module";
    @Component
    MavenProject project;
    @Component
    Settings settings;
    @Parameter(property="guice.modules")
    List<String> modules = Lists.newArrayList();
    @Parameter(property="guice.module")
    String module;
    @Parameter(property="guice.provider")
    String provider;
    @Parameter(property="guice.annotation")
    String annotation;
    @Parameter(property="guice.skip", defaultValue="false")
    boolean skip = false;
    @Parameter(property="guice.forceMojoExecution", defaultValue="false")
    boolean forceMojoExecution = false;

    public void execute() {
        if (this.skip()) {
            return;
        }
        Optional<AbstractModule> module = this.getModule(this);
        ImmutableList filtered = ImmutableList.copyOf((Iterable)Iterables.filter(this.getModules(), (Predicate)NoBlanks.INSTANCE));
        Iterable<AbstractModule> provided = this.getProviderModules();
        Preconditions.checkState((module.isPresent() || !filtered.isEmpty() || !Iterables.isEmpty(provided) ? 1 : 0) != 0, (Object)"no modules");
        List<AbstractModule> modules = this.getModules(module, (List<String>)filtered, provided, new MavenModule(this));
        Injector injector = Guice.createInjector(modules);
        Runnable runnable = this.getRunnable(injector, (Optional<String>)Optionals.fromTrimToNull((String)this.annotation));
        runnable.run();
    }

    private Iterable<AbstractModule> getProviderModules() {
        if (StringUtils.isBlank((CharSequence)this.provider)) {
            return ImmutableList.of();
        }
        Class type = (Class)this.newClass(this.provider.trim());
        Provider provider = (Provider)this.newInstance(type);
        return (Iterable)provider.get();
    }

    private boolean skip() {
        if (this.forceMojoExecution) {
            this.getLog().info((CharSequence)"forced mojo execution");
            return false;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping execution");
            return true;
        }
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"skipping execution for project with packaging 'pom'");
            return true;
        }
        return false;
    }

    protected Optional<AbstractModule> getModule(GuiceMojo mojo) {
        if (StringUtils.isNotBlank((CharSequence)mojo.getModule())) {
            AbstractModule module = this.getModule(mojo.getModule());
            return Optional.of((Object)module);
        }
        return this.getDefaultModule(mojo.getProject());
    }

    private List<AbstractModule> getModules(Optional<AbstractModule> module, List<String> modules, Iterable<AbstractModule> provided, MavenModule maven) {
        ArrayList list = Lists.newArrayList();
        list.add(maven);
        list.addAll(Lists.newArrayList(provided));
        for (String moduleName : modules) {
            AbstractModule element = this.getModule(moduleName);
            list.add(element);
        }
        if (module.isPresent()) {
            list.add(module.get());
        }
        return list;
    }

    private Runnable getRunnable(Injector injector, Optional<String> annotation) {
        if (annotation.isPresent()) {
            Class type = (Class)this.newClass((String)annotation.get());
            Key key = Key.get(Runnable.class, (Class)type);
            return (Runnable)injector.getInstance(key);
        }
        return (Runnable)injector.getInstance(Runnable.class);
    }

    private Optional<AbstractModule> getDefaultModule(MavenProject project) {
        String className = this.getDefaultModuleClassName(project);
        try {
            AbstractModule module = this.getModule(className);
            return Optional.of((Object)module);
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }

    private String getDefaultModuleClassName(MavenProject project) {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        return groupId + "." + this.capitalize(artifactId) + MODULE;
    }

    protected String capitalize(String artifactId) {
        char[] chars = artifactId.replace('_', '-').toCharArray();
        StringBuilder sb = new StringBuilder();
        char prevChar = '\u0000';
        for (char c : chars) {
            if (c != '-') {
                if (prevChar == '\u0000' || prevChar == '-') {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(c);
                }
            }
            prevChar = c;
        }
        return sb.toString();
    }

    protected AbstractModule getModule(String module) {
        Class type = (Class)this.newClass(module);
        return (AbstractModule)this.newInstance(type);
    }

    protected <T> T newClass(String type) {
        try {
            return (T)Class.forName(type);
        }
        catch (Exception e) {
            throw Exceptions.illegalArgument((Throwable)e);
        }
    }

    protected <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw Exceptions.illegalArgument((Throwable)e);
        }
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isForceMojoExecution() {
        return this.forceMojoExecution;
    }

    public void setForceMojoExecution(boolean forceMojoExecution) {
        this.forceMojoExecution = forceMojoExecution;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    private static enum NoBlanks implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String input) {
            return StringUtils.isNotBlank((CharSequence)input);
        }
    }
}

