/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.guice;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.kuali.common.jute.base.Precondition;
import org.kuali.maven.plugins.guice.GuiceMojo;
import org.kuali.maven.plugins.guice.PluginContext;

class MavenModule
extends AbstractModule {
    private final GuiceMojo mojo;

    public MavenModule(GuiceMojo mojo) {
        this.mojo = (GuiceMojo)((Object)Precondition.checkNotNull((Object)((Object)mojo), (String)"mojo"));
    }

    protected void configure() {
        this.bind(MavenProject.class).toInstance((Object)this.mojo.getProject());
        this.bind(Settings.class).toInstance((Object)this.mojo.getSettings());
        this.bind(Log.class).toInstance((Object)this.mojo.getLog());
        this.bind(new TypeLiteral<Map<?, ?>>(){}).annotatedWith(PluginContext.class).toInstance(this.getPluginContext(this.mojo));
    }

    private Map<?, ?> getPluginContext(AbstractMojo mojo) {
        if (mojo.getPluginContext() == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf((Map)mojo.getPluginContext());
    }
}

