/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.kuali.maven.plugins.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInspector {
    private final Logger logger = LoggerFactory.getLogger(HttpInspector.class);
    List<Integer> successCodes = new ArrayList<Integer>();
    List<Integer> continueWaitingCodes = new ArrayList<Integer>();
    int requestTimeout = 3000;
    int sleepInterval = 3000;
    int timeout = 180;

    protected boolean isSuccess(int resultCode) {
        return this.isMatch(resultCode, this.successCodes);
    }

    protected boolean isContinueWaiting(int resultCode) {
        return this.isMatch(resultCode, this.continueWaitingCodes);
    }

    protected boolean isMatch(int i, List<Integer> integers) {
        for (int integer : integers) {
            if (i != integer) continue;
            return true;
        }
        return false;
    }

    protected String getMsg(String msg) {
        return this.getMsg(msg, -1L);
    }

    protected String getMsg(String msg, long l) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        if (l == -1L) {
            return sb.toString();
        }
        sb.append(" - (Timeout in " + l + "s)");
        return sb.toString();
    }

    public Result wait(String url) {
        HttpClient client = this.getHttpClient();
        long now = System.currentTimeMillis();
        long end = now + (long)(this.timeout * 1000);
        this.logger.info(this.getMsg("Determining status for '" + url + "'"));
        do {
            long secondsRemaining;
            Result result;
            if ((result = this.doRequest(client, url, secondsRemaining = (long)Math.ceil((double)(end - System.currentTimeMillis()) / 1000.0))).equals((Object)Result.SUCCESS)) {
                return result;
            }
            if (result.equals((Object)Result.INVALID_HTTP_STATUS_CODE)) {
                this.logger.info("Invalid http status code.  Expected " + this.successCodes);
                return result;
            }
            this.sleep(this.sleepInterval);
        } while (System.currentTimeMillis() <= end);
        this.logger.info("Timed out waiting for response from '" + url + "'");
        return Result.TIMEOUT;
    }

    protected HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        HttpClientParams clientParams = client.getParams();
        DefaultHttpMethodRetryHandler retryHandler = new DefaultHttpMethodRetryHandler(0, false);
        clientParams.setParameter("http.method.retry-handler", (Object)retryHandler);
        clientParams.setParameter("http.socket.timeout", (Object)this.requestTimeout);
        return client;
    }

    protected Result doRequest(HttpClient client, String url, long secondsRemaining) {
        StringBuilder message = new StringBuilder("Status for '" + url + "' is '");
        try {
            GetMethod method = new GetMethod(url);
            client.executeMethod((HttpMethod)method);
            int statusCode = method.getStatusCode();
            String statusText = method.getStatusText();
            boolean success = this.isSuccess(statusCode);
            boolean continueWaiting = this.isContinueWaiting(statusCode);
            message = message.append(statusCode + ":" + statusText + "'");
            if (success) {
                this.logger.info(this.getMsg(message.toString()));
                return Result.SUCCESS;
            }
            if (continueWaiting) {
                this.logger.info(this.getMsg(message.toString()));
                return Result.CONTINUE_WAITING_HTTP_STATUS_CODE;
            }
            this.logger.info(this.getMsg(message.toString(), secondsRemaining));
            return Result.INVALID_HTTP_STATUS_CODE;
        }
        catch (IOException e) {
            this.logger.info(this.getMsg(message.append(e.getMessage() + "'").toString(), secondsRemaining));
            return Result.IO_EXCEPTION;
        }
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getSleepInterval() {
        return this.sleepInterval;
    }

    public void setSleepInterval(int sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int waitTimeout) {
        this.timeout = waitTimeout;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List<Integer> getSuccessCodes() {
        return this.successCodes;
    }

    public void setSuccessCodes(List<Integer> successCodes) {
        this.successCodes = successCodes;
    }

    public List<Integer> getContinueWaitingCodes() {
        return this.continueWaitingCodes;
    }

    public void setContinueWaitingCodes(List<Integer> continueWaitingCodes) {
        this.continueWaitingCodes = continueWaitingCodes;
    }
}

