/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.kuali.maven.plugins.HttpInspector;
import org.kuali.maven.plugins.Result;

public class WaitMojo
extends AbstractMojo {
    private String url;
    private int timeout;
    private int requestTimeout;
    private int sleepInterval;
    private String httpSuccessCodes;
    private String httpContinueWaitingCodes;

    protected HttpInspector getHttpInspector() throws MojoExecutionException {
        HttpInspector inspector = new HttpInspector();
        try {
            BeanUtils.copyProperties((Object)inspector, (Object)((Object)this));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying properties", e);
        }
        inspector.setSuccessCodes(this.splitToList(this.httpSuccessCodes));
        inspector.setContinueWaitingCodes(this.splitToList(this.httpContinueWaitingCodes));
        return inspector;
    }

    private List<Integer> splitToList(String csv) {
        String[] tokens;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String token : tokens = StringUtils.splitByWholeSeparator((String)csv, (String)",")) {
            list.add(new Integer(token));
        }
        return list;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        HttpInspector inspector = this.getHttpInspector();
        Result result = inspector.wait(this.url);
        boolean success = result.equals((Object)Result.SUCCESS);
        if (!success) {
            throw new MojoExecutionException("Waiting for a response from '" + this.url + "' was not successful");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getSleepInterval() {
        return this.sleepInterval;
    }

    public void setSleepInterval(int sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    public String getHttpSuccessCodes() {
        return this.httpSuccessCodes;
    }

    public void setHttpSuccessCodes(String httpSuccessCodes) {
        this.httpSuccessCodes = httpSuccessCodes;
    }

    public String getHttpContinueWaitingCodes() {
        return this.httpContinueWaitingCodes;
    }

    public void setHttpContinueWaitingCodes(String httpContinueWaitingCodes) {
        this.httpContinueWaitingCodes = httpContinueWaitingCodes;
    }
}

