/*-
 * #%L
 * %%
 * Copyright (C) 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.research.gg.fetcher.fetch.status

import com.fasterxml.jackson.annotation.JsonFormat
import java.util.*
import org.kuali.research.gg.fetcher.fetch.FetchConstants.DEFAULT_DATE_FORMAT
import org.kuali.research.gg.fetcher.fetch.Results

data class StatusResults(
    val formStatuses: List<FormStatus> = emptyList(),
    override val accessKey: String?,
    override val errorMsgs: List<String> = emptyList()
) : Results

data class FormStatus(
    val formId: Long,
    val countourFormId: String?,
    val agencyCode: String?,
    val formName: String,
    val shortFormName: String?,
    val description: String?,
    val formVersion: String,
    val ombNumber: String?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val oiraExpireDate: Date?,
    val changeCategory: String?,
    val currentPhase: String?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val targetSystemIntegrationDate: Date?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val targetProdDate: Date?,
    val uatEnv: String?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val lastChangeDate: Date?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val createdDate: Date?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val lastUpdateDate: Date?,
    val hasPdf: Boolean?,
    val hasSchema: Boolean?,
    val status: String?
)
