/*-
 * #%L
 * %%
 * Copyright (C) 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.research.gg.fetcher.context

import java.io.File
import javax.xml.parsers.DocumentBuilder
import javax.xml.parsers.DocumentBuilderFactory
import org.springframework.stereotype.Service
import org.w3c.dom.Document
import org.w3c.dom.Element

@Service
class CatalogFileCreatorServiceImpl : CatalogFileCreatorService {
    override fun createCatalogFile(dir: String): String {

        val catalogStart =
        """
        |<!DOCTYPE catalog PUBLIC "-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN" "http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd">

        |<catalog xmlns="urn:oasis:names:tc:entity:xmlns:xml:catalog" prefer="public">
        """.trimMargin()

        val catalogEnd = "|</catalog>".trimMargin()

        val schemas = File(dir).listFiles().filter { it.isFile && it.name.endsWith(".xsd") }

        val namespaceMappings = schemas.joinToString("\n", "\n", "\n") {
            """
            |<group prefer="public">
                ||<public publicId="${getTargetNamespace(it)}" uri="${it.name}"/>
            |</group>
            """.replaceIndentByMargin("\t").replaceIndentByMargin("\t\t")
        }

        return "$catalogStart$namespaceMappings$catalogEnd"
    }

    private fun getTargetNamespace(file: File): String {
        val documentBuilderFactory: DocumentBuilderFactory = DocumentBuilderFactory.newInstance()
        documentBuilderFactory.isNamespaceAware = true
        val documentBuilder: DocumentBuilder = documentBuilderFactory.newDocumentBuilder()
        val document: Document = documentBuilder.parse(file)

        val map = (document.documentElement as Element).attributes
        return map.getNamedItem("targetNamespace").nodeValue
    }
}
