<?xml version="1.0" encoding="UTF-8"?>
<!-- $Revision:   1.0  $ -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:ObjectiveWorkPlan="http://apply.grants.gov/forms/ObjectiveWorkPlan-V1.1">
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.2in" margin-right="0.2in">
					<fo:region-body margin-top="0.2in" margin-bottom="0.4in"/>
					<fo:region-after extent="0.4in"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="default-page" format="1">
				<fo:static-content flow-name="xsl-region-after">
					<fo:block>
						<fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
						</fo:inline>
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<!--Data components-->
					<!--Block below is for the field named ProjectTitle with FieldID 1-1-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="93.33333333333334px" height="32.72727272727273px" width="561.2121212121212px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ProjectTitle) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ProjectTitle = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ProjectTitle"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the popup named BudgetYear with FieldID 1-2-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="135.60606060606062px" height="13.333333333333334px" width="38.78787878787879px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:BudgetYear) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:BudgetYear = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:BudgetYear"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Objective with FieldID 3-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="188.51515151515153px" height="81.51515151515152px" width="561.2121212121212px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Objective) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Objective = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Objective"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named ExpectedResults with FieldID 4-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="274.39393939393943px" height="48.42424242424243px" width="488.4848484848485px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ExpectedResults) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ExpectedResults = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ExpectedResults"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Activities_1 with FieldID 5-01-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="81.21212121212122px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Activities) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Activities= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Activities"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Activities_2 with FieldID 5-02-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="81.21212121212122px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Activities) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Activities= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Activities"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Activities_3 with FieldID 5-03-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="81.21212121212122px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Activities) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Activities= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Activities"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Activities_4 with FieldID 5-04-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="81.21212121212122px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Activities) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Activities= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Activities"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named ProgramGoal with FieldID 2-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.121212121212125px" hyphenate="true" language="en" keep-together="always" top="135.60606060606062px" height="38.72727272727273px" width="488.4848484848485px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ProgramGoal) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ProgramGoal = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:ProgramGoal"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Position_1 with FieldID 6-01-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="72.121212121212125px" width="134.54545454545456px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Position) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Position= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Position"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Position_2 with FieldID 6-02-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="72.121212121212125px" width="134.54545454545456px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Position) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Position= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Position"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Position_3 with FieldID 6-03-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="72.121212121212125px" width="134.54545454545456px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Position) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Position= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Position"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Position_4 with FieldID 6-04-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="72.121212121212125px" width="134.54545454545456px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Position) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Position= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Position"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodStartDate_1 with FieldID 7-01-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodStartDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodStartDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodStartDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodStartDate_2 with FieldID 7-02-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodStartDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodStartDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodStartDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodStartDate_3 with FieldID 7-03-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodStartDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodStartDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodStartDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodStartDate_4 with FieldID 7-04-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodStartDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodStartDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodStartDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodEndDate_1 with FieldID 8-01-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodEndDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodEndDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodEndDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodEndDate_2 with FieldID 8-02-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodEndDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodEndDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodEndDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodEndDate_3 with FieldID 8-03-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodEndDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodEndDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodEndDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodEndDate_4 with FieldID 8-04-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodEndDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodEndDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodEndDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Non_SalaryPersonnelHours_1 with FieldID 9-01-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Non_SalaryPersonnelHours_2 with FieldID 9-02-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Non_SalaryPersonnelHours_3 with FieldID 9-03-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Non_SalaryPersonnelHours_4 with FieldID 9-04-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Write labels-->
					<!--Block below is for the label named -->
					<!--Block below is for the label named title-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="3.0303030303030303px" hyphenate="true" language="en" keep-together="always" top="24.84848484848485px" height="20px" width="569.6969696969697px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="14pt" font-style="normal" font-family="Helvetica" font-weight="normal">Objective Work Plan</fo:block>
					</fo:block-container>
					<!--Block below is for the label named ProjectTitle_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="79.3939393939394px" height="13.333333333333334px" width="66.66666666666667px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Project:</fo:block>
					</fo:block-container>
					<!--Block below is for the label named BudgetYear_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="126.66666666666667px" height="13.333333333333334px" width="47.27272727272727px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Year:</fo:block>
					</fo:block-container>
					<!--Block below is for the label named Objective_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="177.5757575757576px" height="13.333333333333334px" width="76.36363636363637px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Objective:</fo:block>
					</fo:block-container>
					<!--Block below is for the label named ExpectedResults_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="265.4545454545455px" height="13.333333333333334px" width="231.51515151515153px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Results or Benefits Expected:</fo:block>
					</fo:block-container>
					<!--Block below is for the label named Activities_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="13.333333333333334px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Activities</fo:block>
					</fo:block-container>
					<!--Block below is for the label named ProgramGoal_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.121212121212125px" hyphenate="true" language="en" keep-together="always" top="126.66666666666667px" height="13.333333333333334px" width="166.66666666666669px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Funding Agency Goal:</fo:block>
					</fo:block-container>
					<!--Block below is for the label named Position_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="252.72727272727275px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="13.333333333333334px" width="139.3939393939394px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Position Responsible</fo:block>
					</fo:block-container>
					<!--Block below is for the label named PeriodStartDate_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="394.54545454545456px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="23.03030303030303px" width="57.57575757575758px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Time Period Begin</fo:block>
					</fo:block-container>
					<!--Block below is for the label named expiration_date-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.2727272727273px" hyphenate="true" language="en" keep-together="always" top="11.515151515151516px" height="13.333333333333334px" width="145.45454545454547px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 12/31/2009</fo:block>
					</fo:block-container>
					<!--Block below is for the label named omb_number-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="429.0909090909091px" hyphenate="true" language="en" keep-together="always" top="2.4242424242424243px" height="13.333333333333334px" width="143.63636363636365px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 0980-0204</fo:block>
					</fo:block-container>
					<!--Block below is for the label named PeriodEndDate_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="23.03030303030303px" width="57.57575757575758px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Time Period End</fo:block>
					</fo:block-container>
					<!--Block below is for the label named Non_SalaryPersonnelHours_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="515.1515151515151px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="32.72727272727273px" width="58.78787878787879px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Non-Salary Personnel Hours</fo:block>
					</fo:block-container>
					<!--Draw lines-->
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="23.03030303030303px" width="1.2121212121212122px" height="673.3333333333334px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="173.93939393939394px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="574.5454545454546px" top="23.03030303030303px" width="1.2121212121212122px" height="673.3333333333334px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="263.6363636363636px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="322.42424242424244px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="360.6060606060606px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="392.72727272727275px" top="322.42424242424244px" width="1.2121212121212122px" height="373.93939393939394px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="250.90909090909093px" top="322.42424242424244px" width="1.2121212121212122px" height="373.93939393939394px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="453.33333333333337px" top="322.42424242424244px" width="1.2121212121212122px" height="373.93939393939394px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="513.3333333333334px" top="322.42424242424244px" width="1.2121212121212122px" height="373.93939393939394px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="444.24242424242425px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="527.8787878787879px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="611.5151515151515px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="695.1515151515152px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="23.03030303030303px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="77.57575757575758px" width="573.3333333333334px" height="1.2121212121212122px"/>
				</fo:flow>
			</fo:page-sequence>
			<fo:page-sequence master-reference="default-page" format="1">
				<fo:static-content flow-name="xsl-region-after">
					<fo:block>
						<fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
						</fo:inline>
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<!--Data components-->
					<!--Block below is for the field named Activities_5 with FieldID 5-05-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="81.21212121212122px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Activities) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Activities= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Activities"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Activities_6 with FieldID 5-06-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="81.21212121212122px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Activities) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Activities= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Activities"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Activities_7 with FieldID 5-07-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="81.21212121212122px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Activities) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Activities= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Activities"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Activities_8 with FieldID 5-08-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="81.21212121212122px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Activities) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Activities= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Activities"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named EvaluationCriteria with FieldID 10-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.0606060606060606px" hyphenate="true" language="en" keep-together="always" top="467.3030303030303px" height="76.51515151515152px" width="561.2121212121212px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:EvaluationCriteria) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:EvaluationCriteria = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:EvaluationCriteria"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Position_5 with FieldID 6-05-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="72.121212121212125px" width="134.54545454545456px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Position) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Position= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Position"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Position_6 with FieldID 6-06-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.75757575757578px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="72.121212121212125px" width="134.54545454545456px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Position) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Position= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Position"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Position_7 with FieldID 6-07-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.75757575757578px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="72.121212121212125px" width="134.54545454545456px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Position) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Position= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Position"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Position_8 with FieldID 6-08-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.75757575757578px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="72.121212121212125px" width="134.54545454545456px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Position) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Position= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Position"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodStartDate_5 with FieldID 7-05-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodStartDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodStartDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodStartDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodStartDate_6 with FieldID 7-06-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodStartDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodStartDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodStartDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodStartDate_7 with FieldID 7-07-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodStartDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodStartDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodStartDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodStartDate_8 with FieldID 7-08-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodStartDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodStartDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodStartDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodEndDate_5 with FieldID 8-05-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodEndDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodEndDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodEndDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodEndDate_6 with FieldID 8-06-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodEndDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodEndDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodEndDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodEndDate_7 with FieldID 8-07-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodEndDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodEndDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodEndDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named PeriodEndDate_8 with FieldID 8-08-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodEndDate) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodEndDate= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodEndDate"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Non_SalaryPersonnelHours_5 with FieldID 9-05-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Non_SalaryPersonnelHours_6 with FieldID 9-06-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Non_SalaryPersonnelHours_7 with FieldID 9-07-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named Non_SalaryPersonnelHours_8 with FieldID 9-08-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="52.121212121212125px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Write labels-->
					<!--Block below is for the label named -->
					<!--Block below is for the label named title-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="3.0303030303030303px" hyphenate="true" language="en" keep-together="always" top="24.84848484848485px" height="20px" width="569.6969696969697px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="14pt" font-style="normal" font-family="Helvetica" font-weight="normal">Objective Work Plan</fo:block>
					</fo:block-container>
					<!--Block below is for the label named Activities_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="13.333333333333334px" width="246.06060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Activities</fo:block>
					</fo:block-container>
					<!--Block below is for the label named EvaluationCriteria_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.0606060606060606px" hyphenate="true" language="en" keep-together="always" top="456.3636363636364px" height="13.333333333333334px" width="420.6060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Criteria for Evaluating Results or Benefits Expected:</fo:block>
					</fo:block-container>
					<!--Block below is for the label named Position_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="253.33333333333334px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="13.333333333333334px" width="139.3939393939394px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Position Responsible</fo:block>
					</fo:block-container>
					<!--Block below is for the label named PeriodStartDate_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="395.1515151515152px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="23.03030303030303px" width="57.57575757575758px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Time Period Begin</fo:block>
					</fo:block-container>
					<!--Block below is for the label named expiration_date-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.2727272727273px" hyphenate="true" language="en" keep-together="always" top="11.515151515151516px" height="13.333333333333334px" width="145.45454545454547px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 12/31/2009</fo:block>
					</fo:block-container>
					<!--Block below is for the label named omb_number-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="429.0909090909091px" hyphenate="true" language="en" keep-together="always" top="2.4242424242424243px" height="13.333333333333334px" width="143.63636363636365px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 0980-0204</fo:block>
					</fo:block-container>
					<!--Block below is for the label named PeriodEndDate_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.7575757575758px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="23.03030303030303px" width="57.57575757575758px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Time Period End</fo:block>
					</fo:block-container>
					<!--Block below is for the label named Non_SalaryPersonnelHours_1_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="515.7575757575758px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="33.333333333333336px" width="58.78787878787879px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Non-Salary Personnel Hours</fo:block>
					</fo:block-container>
					<!--Draw lines-->
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="83.63636363636364px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="203.63636363636365px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="393.33333333333337px" top="83.63636363636364px" width="1.2121212121212122px" height="372.1212121212121px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="251.51515151515153px" top="83.63636363636364px" width="1.2121212121212122px" height="372.1212121212121px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="453.93939393939394px" top="83.63636363636364px" width="1.2121212121212122px" height="372.1212121212121px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="513.939393939394px" top="83.63636363636364px" width="1.2121212121212122px" height="372.1212121212121px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="287.2727272727273px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="370.90909090909093px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="454.54545454545456px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="23.03030303030303px" width="1.2121212121212122px" height="520.6060606060606px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="575.1515151515151px" top="23.03030303030303px" width="1.2121212121212122px" height="520.6060606060606px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="542.4242424242425px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="23.03030303030303px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="119.3939393939394px" width="573.3333333333334px" height="1.2121212121212122px"/>
				</fo:flow>
			</fo:page-sequence>
			<fo:page-sequence master-reference="default-page" format="1">
				<fo:static-content flow-name="xsl-region-after">
					<fo:block>
						<fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
						</fo:inline>
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<!--Data components-->
					<!--Block below is for the field named FilenameAtt090 with FieldID 22-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="324.8484848484849px" height="12.121212121212121px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt010) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt010 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt010"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt020 with FieldID 15-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="338.7878787878788px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt020) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt020 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt020"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt030 with FieldID 16-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="352.72727272727275px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt030) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt030 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt030"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt040 with FieldID 17-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="366.6666666666667px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt040) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt040 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt040"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt050 with FieldID 18-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="380.6060606060606px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt050) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt050 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt050"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt060 with FieldID 19-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="394.54545454545456px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt060) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt060 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt060"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt070 with FieldID 20-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="408.4848484848485px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt070) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt070 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt070"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt080 with FieldID 21-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="422.42424242424244px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt080) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt080 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt080"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt090 with FieldID 22-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="436.3636363636364px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt090) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt090 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt090"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt0100 with FieldID 23-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="450.3030303030303px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0100) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0100 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0100"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt0110 with FieldID 24-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="464.24242424242425px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0110) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0110 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0110"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt0120 with FieldID 25-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="478.1818181818182px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0120) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0120 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0120"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt0130 with FieldID 26-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="492.1212121212121px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0130) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0130 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0130"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt0140 with FieldID 27-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="506.06060606060606px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0140) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0140 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0140"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt0150 with FieldID 28-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="520px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0150) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0150 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0150"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt0160 with FieldID 29-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="533.939393939394px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0160) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0160 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0160"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Block below is for the field named FilenameAtt0170 with FieldID 30-0-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="547.8787878787879px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
							<xsl:choose>
								<xsl:when test="not(//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0170) or //ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0170 = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//ObjectiveWorkPlan:ObjectiveWorkPlan/ObjectiveWorkPlan:FilenameAtt0170"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<!--Write labels-->
					<!--Block below is for the label named -->
					<!--Block below is for the label named title-->
					<!--Write labels-->
					<!--Block below is for the label named -->
					<!--Block below is for the label named title-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="3.0303030303030303px" hyphenate="true" language="en" keep-together="always" top="24.84848484848485px" height="20px" width="569.6969696969697px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="14pt" font-style="normal" font-family="Helvetica" font-weight="normal">Objective Work Plan</fo:block>
					</fo:block-container>
					<!--Block below is for the label named d6684e4279-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="276.3636363636364px" height="13.333333333333334px" width="49.09090909090909px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Important:</fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="46.242424242424242px" hyphenate="true" language="en" keep-together="always" top="276.3636363636364px" height="13.333333333333334px" width="554.5454545454546px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Attach additional Objective Work Plan forms, using the blocks below.  Please remember that the files you attach must be Objective Work Plan Pure</fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="285.3636363636364px" height="33.333333333333334px" width="554.5454545454546px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Edge forms that were previously extracted using the process outlined above.  Attaching any other type of file may result in the inability to submit your application to Grants.gov. Note: It is important to attach completed forms only. Attach ONLY PureEdge (.xfd) forms where ALL required fields are filled out. Incomplete or missing data will cause your application to be rejected.</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL3-->
					<!--Block below is for the label named FilenameAtt01_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="324.8484848484849px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">1) Please attach Attachment 1</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt02_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="338.7878787878788px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">2) Please attach Attachment 2</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt03_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="352.72727272727275px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">3) Please attach Attachment 3</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt04_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="366.6666666666667px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">4) Please attach Attachment 4</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt05_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="380.6060606060606px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">5) Please attach Attachment 5</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt06_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="394.54545454545456px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">6) Please attach Attachment 6</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt07_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="408.4848484848485px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">7) Please attach Attachment 7</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt08_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="422.42424242424244px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">8) Please attach Attachment 8</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt09_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="436.3636363636364px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">9) Please attach Attachment 9</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt010_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="450.3030303030303px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">10) Please attach Attachment 10</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt011_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="464.24242424242425px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">11) Please attach Attachment 11</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt012_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="478.1818181818182px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">12) Please attach Attachment 12</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt013_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="492.1212121212121px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">13) Please attach Attachment 13</fo:block>
					</fo:block-container>
					<!--Block below is for the label named FilenameAtt014_LBL-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="506.06060606060606px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">14) Please attach Attachment 14</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL11-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="520px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">15) Please attach Attachment 15</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL12-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="533.939393939394px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">16) Please attach Attachment 16</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL13-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="547.8787878787879px" height="13.333333333333334px" width="120.60606060606061px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">17) Please attach Attachment 17</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL1-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="86.06060606060606px" height="13.333333333333334px" width="569.0909090909091px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">You may attach up to 17 additional Objective Work Plan forms here.  To extract, fill and attach each additional form, follow these steps: </fo:block>
						<!--Block below is for the label named LABEL4-->
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="98.7878787878788px" height="13.333333333333334px" width="560.6060606060606px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">- Select the "Select to Extract the Objective Work Plan Attachment" button below.</fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="120px" height="13.333333333333334px" width="562.4242424242425px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">- Save the file using a descriptive name to help you remember the content of the supplemental form that you are creating.  When assigning a name to the file,</fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="129.69696969696972px" height="13.333333333333334px" width="558.1818181818182px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">please remember to give it the extension ".xfd" (for example, "Objective_1.xfd").  If you do not name your file with the ".xfd" extension you will be unable to</fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="139.3939393939394px" height="13.333333333333334px" width="557.5757575757576px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">open it later, using the PureEdge viewer software. </fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="161.21212121212122px" height="13.333333333333334px" width="555.1515151515151px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">- Use the "Open Form" tool on the PureEdge viewer to open the new form you just saved. </fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="181.81818181818184px" height="13.333333333333334px" width="566.6666666666667px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">- Enter your additional Objective information in this supplemental form, similar to the Objective Work Plan form that you see in the main body of your application.</fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="200.60606060606062px" height="13.333333333333334px" width="560px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">- When you have completed entering information in the supplemental form, save and close it.</fo:block>
					</fo:block-container>
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="220.60606060606062px" height="16.363636363636363px" width="554.5454545454546px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">- Return to this page and attach the saved supplemental form you just filled in, to one of the blocks provided on this "attachments" form.</fo:block>
					</fo:block-container>
					<!--Block below is for the label named expiration_date-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.2727272727273px" hyphenate="true" language="en" keep-together="always" top="11.515151515151516px" height="13.333333333333334px" width="145.45454545454547px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 12/31/2009</fo:block>
					</fo:block-container>
					<!--Block below is for the label named omb_number-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="429.0909090909091px" hyphenate="true" language="en" keep-together="always" top="2.4242424242424243px" height="13.333333333333334px" width="143.63636363636365px">
						<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 0980-0204</fo:block>
					</fo:block-container>
					<!--Draw lines-->
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="84.24242424242425px" width="573.3333333333334px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="575.1515151515151px" top="23.03030303030303px" width="1.2121212121212122px" height="679.3939393939394px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="23.03030303030303px" width="1.2121212121212122px" height="679.3939393939394px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="701.2121212121212px" width="573.939393939394px" height="1.2121212121212122px"/>
					<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="23.03030303030303px" width="573.3333333333334px" height="1.2121212121212122px"/>
				</fo:flow>
			</fo:page-sequence>
			<!-- Subforms are below -->
			<xsl:for-each select="//ObjectiveWorkPlan:ObjectiveWorkPlan_Att">
				<fo:page-sequence master-reference="default-page" format="1">
					<fo:static-content flow-name="xsl-region-after">
						<fo:block>
							<fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
							</fo:inline>
						</fo:block>
					</fo:static-content>
					<fo:flow flow-name="xsl-region-body">
						<!--Data components-->
						<!--Block below is for the field named ProjectTitle with FieldID 1-1-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="93.33333333333334px" height="32.72727272727273px" width="561.2121212121212px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:ProjectTitle) or ObjectiveWorkPlan:ProjectTitle = ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:ProjectTitle"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the popup named BudgetYear with FieldID 1-2-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="135.60606060606062px" height="13.333333333333334px" width="38.78787878787879px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:BudgetYear) or ObjectiveWorkPlan:BudgetYear = ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:BudgetYear"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Objective with FieldID 3-0-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="188.51515151515153px" height="81.51515151515152px" width="561.2121212121212px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Objective) or ObjectiveWorkPlan:Objective = ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Objective"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named ExpectedResults with FieldID 4-0-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="274.39393939393943px" height="48.42424242424243px" width="488.4848484848485px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:ExpectedResults) or ObjectiveWorkPlan:ExpectedResults = ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:ExpectedResults"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Activities_1 with FieldID 5-01-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="81.21212121212122px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Activities) or ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Activities= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Activities"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Activities_2 with FieldID 5-02-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="81.21212121212122px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Activities) or ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Activities= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Activities"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Activities_3 with FieldID 5-03-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="81.21212121212122px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Activities) or ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Activities= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Activities"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Activities_4 with FieldID 5-04-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="81.21212121212122px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Activities) or ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Activities= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Activities"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named ProgramGoal with FieldID 2-0-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.121212121212125px" hyphenate="true" language="en" keep-together="always" top="135.60606060606062px" height="38.72727272727273px" width="488.4848484848485px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:ProgramGoal) or ObjectiveWorkPlan:ProgramGoal = ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:ProgramGoal"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Position_1 with FieldID 6-01-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="72.121212121212125px" width="134.54545454545456px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Position) or ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Position= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Position"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Position_2 with FieldID 6-02-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="72.121212121212125px" width="134.54545454545456px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Position) or ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Position= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Position"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Position_3 with FieldID 6-03-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="72.121212121212125px" width="134.54545454545456px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Position) or ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Position= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Position"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Position_4 with FieldID 6-04-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="72.121212121212125px" width="134.54545454545456px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Position) or ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Position= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Position"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodStartDate_1 with FieldID 7-01-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodStartDate) or ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodStartDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodStartDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodStartDate_2 with FieldID 7-02-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodStartDate) or ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodStartDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodStartDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodStartDate_3 with FieldID 7-03-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodStartDate) or ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodStartDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodStartDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodStartDate_4 with FieldID 7-04-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodStartDate) or ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodStartDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodStartDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodEndDate_1 with FieldID 8-01-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodEndDate) or ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodEndDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:PeriodEndDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodEndDate_2 with FieldID 8-02-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodEndDate) or ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodEndDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:PeriodEndDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodEndDate_3 with FieldID 8-03-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodEndDate) or ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodEndDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:PeriodEndDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodEndDate_4 with FieldID 8-04-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodEndDate) or ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodEndDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:PeriodEndDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Non_SalaryPersonnelHours_1 with FieldID 9-01-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="362.42424242424244px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(//ObjectiveWorkPlan:Group1[1]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Non_SalaryPersonnelHours_2 with FieldID 9-02-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="446.06060606060606px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(//ObjectiveWorkPlan:Group1[2]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Non_SalaryPersonnelHours_3 with FieldID 9-03-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="529.6969696969697px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(//ObjectiveWorkPlan:Group1[3]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Non_SalaryPersonnelHours_4 with FieldID 9-04-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="613.3333333333334px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(//ObjectiveWorkPlan:Group1[4]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Write labels-->
						<!--Block below is for the label named -->
						<!--Block below is for the label named title-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="3.0303030303030303px" hyphenate="true" language="en" keep-together="always" top="24.84848484848485px" height="20px" width="569.6969696969697px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="14pt" font-style="normal" font-family="Helvetica" font-weight="normal">Objective Work Plan</fo:block>
						</fo:block-container>
						<!--Block below is for the label named ProjectTitle_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="79.3939393939394px" height="13.333333333333334px" width="66.66666666666667px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Project:</fo:block>
						</fo:block-container>
						<!--Block below is for the label named BudgetYear_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="126.66666666666667px" height="13.333333333333334px" width="47.27272727272727px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Year:</fo:block>
						</fo:block-container>
						<!--Block below is for the label named Objective_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="177.5757575757576px" height="13.333333333333334px" width="76.36363636363637px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Objective:</fo:block>
						</fo:block-container>
						<!--Block below is for the label named ExpectedResults_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="265.4545454545455px" height="13.333333333333334px" width="231.51515151515153px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Results or Benefits Expected:</fo:block>
						</fo:block-container>
						<!--Block below is for the label named Activities_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="13.333333333333334px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Activities</fo:block>
						</fo:block-container>
						<!--Block below is for the label named ProgramGoal_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.121212121212125px" hyphenate="true" language="en" keep-together="always" top="126.66666666666667px" height="13.333333333333334px" width="166.66666666666669px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Funding Agency Goal:</fo:block>
						</fo:block-container>
						<!--Block below is for the label named Position_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="252.72727272727275px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="13.333333333333334px" width="139.3939393939394px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Position Responsible</fo:block>
						</fo:block-container>
						<!--Block below is for the label named PeriodStartDate_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="394.54545454545456px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="23.03030303030303px" width="57.57575757575758px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Time Period Begin</fo:block>
						</fo:block-container>
						<!--Block below is for the label named expiration_date-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.2727272727273px" hyphenate="true" language="en" keep-together="always" top="11.515151515151516px" height="13.333333333333334px" width="145.45454545454547px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 12/31/2009</fo:block>
						</fo:block-container>
						<!--Block below is for the label named omb_number-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="429.0909090909091px" hyphenate="true" language="en" keep-together="always" top="2.4242424242424243px" height="13.333333333333334px" width="143.63636363636365px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 0980-0204</fo:block>
						</fo:block-container>
						<!--Block below is for the label named PeriodEndDate_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="23.03030303030303px" width="57.57575757575758px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Time Period End</fo:block>
						</fo:block-container>
						<!--Block below is for the label named Non_SalaryPersonnelHours_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="515.1515151515151px" hyphenate="true" language="en" keep-together="always" top="324.24242424242425px" height="32.72727272727273px" width="58.78787878787879px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Non-Salary Personnel Hours</fo:block>
						</fo:block-container>
						<!--Draw lines-->
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="23.03030303030303px" width="1.2121212121212122px" height="673.3333333333334px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="173.93939393939394px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="574.5454545454546px" top="23.03030303030303px" width="1.2121212121212122px" height="673.3333333333334px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="263.6363636363636px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="322.42424242424244px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="360.6060606060606px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="392.72727272727275px" top="322.42424242424244px" width="1.2121212121212122px" height="373.93939393939394px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="250.90909090909093px" top="322.42424242424244px" width="1.2121212121212122px" height="373.93939393939394px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="453.33333333333337px" top="322.42424242424244px" width="1.2121212121212122px" height="373.93939393939394px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="513.3333333333334px" top="322.42424242424244px" width="1.2121212121212122px" height="373.93939393939394px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="444.24242424242425px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="527.8787878787879px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="611.5151515151515px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="695.1515151515152px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="23.03030303030303px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="77.57575757575758px" width="573.3333333333334px" height="1.2121212121212122px"/>
					</fo:flow>
				</fo:page-sequence>
				<fo:page-sequence master-reference="default-page" format="1">
					<fo:static-content flow-name="xsl-region-after">
						<fo:block>
							<fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
							</fo:inline>
						</fo:block>
					</fo:static-content>
					<fo:flow flow-name="xsl-region-body">
						<!--Data components-->
						<!--Block below is for the field named Activities_5 with FieldID 5-05-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="81.21212121212122px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Activities) or ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Activities= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Activities"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Activities_6 with FieldID 5-06-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="81.21212121212122px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Activities) or ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Activities= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Activities"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Activities_7 with FieldID 5-07-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="81.21212121212122px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Activities) or ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Activities= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Activities"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Activities_8 with FieldID 5-08-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="81.21212121212122px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Activities) or ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Activities= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Activities"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named EvaluationCriteria with FieldID 10-0-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.0606060606060606px" hyphenate="true" language="en" keep-together="always" top="467.3030303030303px" height="76.51515151515152px" width="561.2121212121212px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:EvaluationCriteria) or ObjectiveWorkPlan:EvaluationCriteria = ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:EvaluationCriteria"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Position_5 with FieldID 6-05-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.15151515151516px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="72.121212121212125px" width="134.54545454545456px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Position) or ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Position= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Position"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Position_6 with FieldID 6-06-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.75757575757578px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="72.121212121212125px" width="134.54545454545456px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Position) or ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Position= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Position"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Position_7 with FieldID 6-07-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.75757575757578px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="72.121212121212125px" width="134.54545454545456px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Position) or ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Position= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Position"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Position_8 with FieldID 6-08-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.75757575757578px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="72.121212121212125px" width="134.54545454545456px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Position) or ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Position= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Position"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodStartDate_5 with FieldID 7-05-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodStartDate) or ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodStartDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodStartDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodStartDate_6 with FieldID 7-06-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodStartDate) or ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodStartDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodStartDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodStartDate_7 with FieldID 7-07-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodStartDate) or ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodStartDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodStartDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodStartDate_8 with FieldID 7-08-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodStartDate) or ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodStartDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodStartDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodEndDate_5 with FieldID 8-05-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodEndDate) or ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodEndDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:PeriodEndDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodEndDate_6 with FieldID 8-06-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodEndDate) or ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodEndDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:PeriodEndDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodEndDate_7 with FieldID 8-07-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodEndDate) or ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodEndDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:PeriodEndDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named PeriodEndDate_8 with FieldID 8-08-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodEndDate) or ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodEndDate= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="formatDate">
											<xsl:with-param name="value" select="ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:PeriodEndDate"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Non_SalaryPersonnelHours_5 with FieldID 9-05-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="121.21212121212122px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(//ObjectiveWorkPlan:Group1[5]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Non_SalaryPersonnelHours_6 with FieldID 9-06-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(//ObjectiveWorkPlan:Group1[6]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Non_SalaryPersonnelHours_7 with FieldID 9-07-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="289.0909090909091px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(//ObjectiveWorkPlan:Group1[7]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Block below is for the field named Non_SalaryPersonnelHours_8 with FieldID 9-08-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="518.7878787878789px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="52.121212121212125px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
								<xsl:choose>
									<xsl:when test="not(ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Non_SalaryPersonnelHours) or ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Non_SalaryPersonnelHours= ''">
										<fo:inline color="#FFFFFF">&#160;</fo:inline>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(//ObjectiveWorkPlan:Group1[8]/ObjectiveWorkPlan:Non_SalaryPersonnelHours, '#,##0')"/>
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:block-container>
						<!--Write labels-->
						<!--Block below is for the label named -->
						<!--Block below is for the label named title-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="3.0303030303030303px" hyphenate="true" language="en" keep-together="always" top="24.84848484848485px" height="20px" width="569.6969696969697px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="14pt" font-style="normal" font-family="Helvetica" font-weight="normal">Objective Work Plan</fo:block>
						</fo:block-container>
						<!--Block below is for the label named Activities_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.848484848484849px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="13.333333333333334px" width="246.06060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Activities</fo:block>
						</fo:block-container>
						<!--Block below is for the label named EvaluationCriteria_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.0606060606060606px" hyphenate="true" language="en" keep-together="always" top="456.3636363636364px" height="13.333333333333334px" width="420.6060606060606px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Criteria for Evaluating Results or Benefits Expected:</fo:block>
						</fo:block-container>
						<!--Block below is for the label named Position_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="253.33333333333334px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="13.333333333333334px" width="139.3939393939394px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Position Responsible</fo:block>
						</fo:block-container>
						<!--Block below is for the label named PeriodStartDate_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="395.1515151515152px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="23.03030303030303px" width="57.57575757575758px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Time Period Begin</fo:block>
						</fo:block-container>
						<!--Block below is for the label named expiration_date-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.2727272727273px" hyphenate="true" language="en" keep-together="always" top="11.515151515151516px" height="13.333333333333334px" width="145.45454545454547px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 12/31/2009</fo:block>
						</fo:block-container>
						<!--Block below is for the label named omb_number-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="429.0909090909091px" hyphenate="true" language="en" keep-together="always" top="2.4242424242424243px" height="13.333333333333334px" width="143.63636363636365px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 0980-0204</fo:block>
						</fo:block-container>
						<!--Block below is for the label named PeriodEndDate_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.7575757575758px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="23.03030303030303px" width="57.57575757575758px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Time Period End</fo:block>
						</fo:block-container>
						<!--Block below is for the label named Non_SalaryPersonnelHours_1_LBL-->
						<fo:block-container background-color="transparent" border-style="none" position="absolute" left="515.7575757575758px" hyphenate="true" language="en" keep-together="always" top="85.45454545454545px" height="33.333333333333336px" width="58.78787878787879px">
							<fo:block border-color="gray"  background-color="transparent" color="000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Non-Salary Personnel Hours</fo:block>
						</fo:block-container>
						<!--Draw lines-->
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="83.63636363636364px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="203.63636363636365px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="393.33333333333337px" top="83.63636363636364px" width="1.2121212121212122px" height="372.1212121212121px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="251.51515151515153px" top="83.63636363636364px" width="1.2121212121212122px" height="372.1212121212121px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="453.93939393939394px" top="83.63636363636364px" width="1.2121212121212122px" height="372.1212121212121px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="513.939393939394px" top="83.63636363636364px" width="1.2121212121212122px" height="372.1212121212121px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="287.2727272727273px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="370.90909090909093px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="454.54545454545456px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="23.03030303030303px" width="1.2121212121212122px" height="520.6060606060606px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="575.1515151515151px" top="23.03030303030303px" width="1.2121212121212122px" height="520.6060606060606px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="542.4242424242425px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="2.4242424242424243px" top="23.03030303030303px" width="573.3333333333334px" height="1.2121212121212122px"/>
						<fo:block-container background-color="gray" border-style="none" position="absolute" left="3.0303030303030303px" top="119.3939393939394px" width="573.3333333333334px" height="1.2121212121212122px"/>
					</fo:flow>
				</fo:page-sequence>
			</xsl:for-each>
		</fo:root>
	</xsl:template>
	<xsl:template name="radioButton">
		<xsl:param name="value"/>
		<xsl:param name="schemaChoice">Yes</xsl:param>
		<xsl:choose>
			<xsl:when test="$value = $schemaChoice">
				<fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats" font-size="8pt">&#x25cf;</fo:inline>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats" font-size="8pt">&#x274d;</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="checkbox">
		<xsl:param name="value"/>
		<xsl:param name="schemaChoice">Yes</xsl:param>
		<xsl:if test="$value = $schemaChoice">
			<fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats" font-size="8pt">&#x2714;</fo:inline>
		</xsl:if>
	</xsl:template>
	<xsl:template name="formatDate">
		<xsl:param name="value"/>
		<xsl:if test="$value != ''">
			<xsl:value-of select="format-number(substring($value,6,2), '00')"/>
			<xsl:text>/</xsl:text>
			<xsl:value-of select="format-number(substring($value,9,2), '00')"/>
			<xsl:text>/</xsl:text>
			<xsl:value-of select="format-number(substring($value,1,4), '0000')"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addBlankLines">
		<xsl:param name="numLines"/>
		<xsl:if test="string($numLines) != ''">
			<xsl:if test="$numLines &gt; 0">
				<fo:block border-color="gray"  xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0">
					<fo:leader leader-pattern="space"/>
				</fo:block>
				<xsl:call-template name="addBlankLines">
					<xsl:with-param name="numLines" select="$numLines - 1"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
