/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.environment.internal;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.environment.Env;
import org.kuali.research.grants.sys.environment.internal.EnvAwareWebFilter;
import org.kuali.research.grants.sys.environment.internal.MutableEnvService;
import org.springframework.web.filter.OncePerRequestFilter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/kuali/research/grants/sys/environment/internal/EnvAwareWebFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "mutableEnvService", "Lorg/kuali/research/grants/sys/environment/internal/MutableEnvService;", "(Lorg/kuali/research/grants/sys/environment/internal/MutableEnvService;)V", "urlRegex", "Lkotlin/text/Regex;", "getUrlRegex", "()Lkotlin/text/Regex;", "doFilterInternal", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "fromHeaders", "Lorg/kuali/research/grants/sys/environment/Env;", "fromUrl", "Constants", "grants"})
@SourceDebugExtension(value={"SMAP\nEnvAwareWebFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvAwareWebFilter.kt\norg/kuali/research/grants/sys/environment/internal/EnvAwareWebFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n766#2:85\n857#2,2:86\n766#2:88\n857#2,2:89\n1549#2:91\n1620#2,3:92\n1549#2:95\n1620#2,3:96\n*S KotlinDebug\n*F\n+ 1 EnvAwareWebFilter.kt\norg/kuali/research/grants/sys/environment/internal/EnvAwareWebFilter\n*L\n42#1:85\n42#1:86,2\n43#1:88\n43#1:89,2\n45#1:91\n45#1:92,3\n46#1:95\n46#1:96,3\n*E\n"})
public final class EnvAwareWebFilter
extends OncePerRequestFilter {
    @NotNull
    private final MutableEnvService mutableEnvService;
    @NotNull
    private final Regex urlRegex;

    public EnvAwareWebFilter(@NotNull MutableEnvService mutableEnvService) {
        Intrinsics.checkNotNullParameter((Object)mutableEnvService, (String)"mutableEnvService");
        this.mutableEnvService = mutableEnvService;
        this.urlRegex = new Regex("(?<tenant>.*?)\\..*?(?:-(?<lane>.*?))?\\..*");
    }

    @NotNull
    public final Regex getUrlRegex() {
        return this.urlRegex;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
            try {
                Env headerTenantLane = this.fromHeaders(request);
                if (headerTenantLane != null && this.mutableEnvService.isValidTenant(headerTenantLane)) {
                    this.mutableEnvService.setEnv(headerTenantLane);
                    break block4;
                }
                Env urlTenantLane = this.fromUrl(request);
                if (urlTenantLane != null && this.mutableEnvService.isValidTenant(urlTenantLane)) {
                    this.mutableEnvService.setEnv(urlTenantLane);
                    break block4;
                }
                this.mutableEnvService.removeEnv();
                response.sendError(404);
                return;
            }
            catch (Throwable t) {
                this.mutableEnvService.removeEnv();
                this.logger.error((Object)t.getMessage(), t);
                response.sendError(404);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - void declaration
     */
    private final Env fromHeaders(HttpServletRequest request) {
        Env env;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterTo$iv$iv2;
        Enumeration enumeration = request.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaderNames(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$filter$iv2 = arrayList;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String k = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals((String)Constants.INSTANCE.getTENANT_HEADER(), (String)k, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tenantHeaderNames = (List)destination$iv$iv;
        Enumeration enumeration2 = request.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration2, (String)"getHeaderNames(...)");
        ArrayList arrayList2 = Collections.list(enumeration2);
        Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"list(...)");
        Iterable $i$f$filter22 = arrayList2;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String k = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals((String)Constants.INSTANCE.getLANE_HEADER(), (String)k, (boolean)true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List laneHeaderNames = (List)destination$iv$iv2;
        Iterable $this$map$iv = tenantHeaderNames;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            Enumeration enumeration3 = request.getHeaders((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)enumeration3, (String)"getHeaders(...)");
            ArrayList arrayList3 = Collections.list(enumeration3);
            Intrinsics.checkNotNullExpressionValue(arrayList3, (String)"list(...)");
            collection.add((List)arrayList3);
        }
        Set tenantHeaderValues = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv3)));
        Iterable $this$map$iv2 = laneHeaderNames;
        boolean $i$f$map2 = false;
        destination$iv$iv3 = $this$map$iv2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl2 = (String)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            Enumeration enumeration4 = request.getHeaders((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)enumeration4, (String)"getHeaders(...)");
            ArrayList arrayList4 = Collections.list(enumeration4);
            Intrinsics.checkNotNullExpressionValue(arrayList4, (String)"list(...)");
            collection.add((List)arrayList4);
        }
        Set laneHeaderValues = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv4)));
        if (tenantHeaderValues.size() == 1 && laneHeaderValues.size() == 1) {
            Object object = CollectionsKt.first((Iterable)tenantHeaderValues);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            String string = (String)object;
            Object object2 = CollectionsKt.first((Iterable)laneHeaderValues);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first(...)");
            env = new Env(string, (String)object2);
        } else if (tenantHeaderValues.isEmpty() && laneHeaderValues.isEmpty()) {
            env = null;
        } else {
            this.logger.warn((Object)("Invalid tenant/lane headers " + Constants.INSTANCE.getTENANT_HEADER() + "=" + tenantHeaderValues + " " + Constants.INSTANCE.getLANE_HEADER() + "=" + laneHeaderValues));
            env = null;
        }
        return env;
    }

    private final Env fromUrl(HttpServletRequest request) {
        Env env;
        String host = new URI(request.getRequestURL().toString()).getHost();
        Intrinsics.checkNotNull((Object)host);
        MatchResult match = Regex.find$default((Regex)this.urlRegex, (CharSequence)host, (int)0, (int)2, null);
        if (match != null) {
            CharSequence charSequence;
            Object lane;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"tenant");
            String tenant = matchGroup != null ? matchGroup.getValue() : null;
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"lane");
            if (object == null || (object = object.getValue()) == null) {
                object = lane = "prd";
            }
            if ((charSequence = (CharSequence)tenant) == null || charSequence.length() == 0) {
                this.logger.warn((Object)("Unable to parse url for tenant/lane " + host));
                env = null;
            } else {
                env = new Env(tenant, (String)lane);
            }
        } else {
            this.logger.warn((Object)("Unable to parse url for tenant/lane " + host));
            env = null;
        }
        return env;
    }
}

