/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.environment.internal;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.environment.Env;
import org.kuali.research.grants.sys.environment.EnvService;
import org.kuali.research.grants.sys.environment.internal.EnvServiceImpl;
import org.kuali.research.grants.sys.environment.internal.MutableEnvService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001aB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kuali/research/grants/sys/environment/internal/EnvServiceImpl;", "Lorg/kuali/research/grants/sys/environment/EnvService;", "Lorg/kuali/research/grants/sys/environment/internal/MutableEnvService;", "internalTenant", "", "internalLane", "kualiEnvironments", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "internal", "Lorg/kuali/research/grants/sys/environment/Env;", "doInInternal", "R", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "env", "isSet", "", "isValidTenant", "lane", "removeEnv", "", "setEnv", "setEnvUnsafe", "tenant", "EnvState", "grants"})
public final class EnvServiceImpl
implements EnvService,
MutableEnvService {
    @NotNull
    private final Set<String> kualiEnvironments;
    @NotNull
    private final Env internal;

    public EnvServiceImpl(@NotNull String internalTenant, @NotNull String internalLane, @NotNull Set<String> kualiEnvironments) {
        Intrinsics.checkNotNullParameter((Object)internalTenant, (String)"internalTenant");
        Intrinsics.checkNotNullParameter((Object)internalLane, (String)"internalLane");
        Intrinsics.checkNotNullParameter(kualiEnvironments, (String)"kualiEnvironments");
        this.kualiEnvironments = kualiEnvironments;
        this.internal = new Env(internalTenant, internalLane);
    }

    public boolean isSet() {
        return EnvState.INSTANCE.getEnvs().get() != null;
    }

    @NotNull
    public String tenant() {
        return this.env().getTenant();
    }

    @NotNull
    public String lane() {
        return this.env().getLane();
    }

    @NotNull
    public Env env() {
        Env env = (Env)EnvState.INSTANCE.getEnvs().get();
        if (env == null) {
            throw new IllegalStateException("environment not set");
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doInInternal(@NotNull Function0<? extends R> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (this.isSet()) {
            Env previousEnv = this.env();
            try {
                this.setEnvUnsafe(this.internal);
                Object object = task.invoke();
                return (R)object;
            }
            finally {
                this.setEnvUnsafe(previousEnv);
            }
        }
        try {
            this.setEnvUnsafe(this.internal);
            Object object = task.invoke();
            return (R)object;
        }
        finally {
            this.removeEnv();
        }
    }

    public void setEnv(@NotNull Env env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        if (!this.isValidTenant(env)) {
            throw new IllegalArgumentException("environment " + env + " is not valid");
        }
        this.setEnvUnsafe(env);
    }

    public boolean isValidTenant(@NotNull Env env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        return !Intrinsics.areEqual((Object)env, (Object)this.internal) && this.kualiEnvironments.contains(env.getTenant() + "-" + env.getLane());
    }

    private final void setEnvUnsafe(Env env) {
        EnvState.INSTANCE.getEnvs().set(env);
    }

    public void removeEnv() {
        EnvState.INSTANCE.getEnvs().remove();
    }
}

