/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.action;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.kernel.exceptions.BadPasswordException;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.CustomSettingsAction;
import org.kuali.research.pdf.action.MultiSourceAction;
import org.kuali.research.pdf.action.SingleSourceAction;
import org.kuali.research.pdf.action.SingleTargetAction;
import org.kuali.research.pdf.job.JobAware;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.model.Level;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Messages;
import org.kuali.research.pdf.sys.model.Props;
import org.kuali.research.pdf.sys.model.RequestMetaData;
import org.kuali.research.pdf.sys.model.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJH\u0010\r\u001a\u0002H\u000e\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015JH\u0010\u0016\u001a\u0002H\u000e\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015JH\u0010\u0017\u001a\u0002H\u000e\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015J\\\u0010\u0018\u001a\u0002H\u000e\"\"\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u0019*\b\u0012\u0004\u0012\u0002H\u000e0\u001a2\u0006\u0010\u0010\u001a\u0002H\u000e2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015Jb\u0010\u001b\u001a\u0002H\u000e\"\"\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u0019*\b\u0012\u0004\u0012\u0002H\u000e0\u001a2\u0006\u0010\u0010\u001a\u0002H\u000e2'\u0010\u0011\u001a#\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u000e0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eJ\\\u0010\u001f\u001a\u0002H\u000e\"\"\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u0019*\b\u0012\u0004\u0012\u0002H\u000e0\u001a2\u0006\u0010\u0010\u001a\u0002H\u000e2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015JR\u0010 \u001a\u0002H\u000e\"\u0018\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u00192\u0006\u0010\u0010\u001a\u0002H\u000e2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015JX\u0010!\u001a\u0002H\u000e\"\u0018\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u00192\u0006\u0010\u0010\u001a\u0002H\u000e2'\u0010\u0011\u001a#\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u000e0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eJR\u0010\"\u001a\u0002H\u000e\"\u0018\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u00192\u0006\u0010\u0010\u001a\u0002H\u000e2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u0011H\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010#\u001a\u00020$2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0012J\u0014\u0010%\u001a\u00020&2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lorg/kuali/research/pdf/action/ActionHelperServiceImpl;", "Lorg/kuali/research/pdf/action/ActionHelperService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "actionLinkInitFinalizeService", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "<init>", "(Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;)V", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getActionLinkInitFinalizeService", "()Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "initManual", "T", "Lorg/kuali/research/pdf/action/Action;", "action", "actionLogic", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Lorg/kuali/research/pdf/action/Action;Lkotlin/jvm/functions/Function1;)Lorg/kuali/research/pdf/action/Action;", "execManual", "finalizeManual", "initOneToOne", "Lorg/kuali/research/pdf/action/SingleSourceAction;", "Lorg/kuali/research/pdf/action/SingleTargetAction;", "execOneToOne", "Lkotlin/Function2;", "Lcom/itextpdf/kernel/pdf/PdfDocument;", "(Lorg/kuali/research/pdf/action/Action;Lkotlin/jvm/functions/Function2;)Lorg/kuali/research/pdf/action/Action;", "finalizeOneToOne", "initOneToUnit", "execOneToUnit", "finalizeOneToUnit", "verifyInit", "", "getDocumentProperties", "Lcom/itextpdf/kernel/pdf/StampingProperties;", "pdf"})
@SourceDebugExtension(value={"SMAP\nActionHelperServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionHelperServiceImpl.kt\norg/kuali/research/pdf/action/ActionHelperServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,354:1\n1761#2,3:355\n1761#2,3:358\n1761#2,3:361\n*S KotlinDebug\n*F\n+ 1 ActionHelperServiceImpl.kt\norg/kuali/research/pdf/action/ActionHelperServiceImpl\n*L\n64#1:355,3\n126#1:358,3\n169#1:361,3\n*E\n"})
public class ActionHelperServiceImpl
implements ActionHelperService,
Logging {
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final ActionLinkInitFinalizeService actionLinkInitFinalizeService;

    public ActionHelperServiceImpl(@Autowired @NotNull LinkService linkService, @Autowired @NotNull ActionLinkInitFinalizeService actionLinkInitFinalizeService) {
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)actionLinkInitFinalizeService, (String)"actionLinkInitFinalizeService");
        this.linkService = linkService;
        this.actionLinkInitFinalizeService = actionLinkInitFinalizeService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public ActionLinkInitFinalizeService getActionLinkInitFinalizeService() {
        return this.actionLinkInitFinalizeService;
    }

    @Override
    @NotNull
    public <T extends Action<T>> T initManual(@NotNull T action, @NotNull Function1<? super T, ? extends T> actionLogic) {
        boolean bl;
        Action completedAction;
        block6: {
            Action action2;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
            T processingAction = action.copyUpdatingProgress(Status.INITIALIZING, Message.Companion.info("Action " + action.getName() + " " + action.getActionId() + " Initializing", "action.initializing", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName()))));
            try {
                this.verifyInit((Action<?>)processingAction);
                action2 = (Action)actionLogic.invoke(processingAction);
            }
            catch (Exception e) {
                this.getLogger().error((CharSequence)("Action " + action.getName() + " " + action.getActionId() + " initialization failed"), (Throwable)e);
                String string = e.getMessage();
                if (string == null) {
                    string = "unknown";
                }
                return processingAction.copyUpdatingProgress(Status.FAIL, Message.Companion.error(string, "unknown.error", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName()))));
            }
            completedAction = action2;
            Iterable $this$any$iv = ((Messages)completedAction).getMessages();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message m = (Message)element$iv;
                    boolean bl2 = false;
                    if (!(m.getLevel() == Level.FATAL || m.getLevel() == Level.ERROR)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean failedMessages = bl;
        return !failedMessages ? completedAction.copyUpdatingProgress(Status.PROCESSING, Message.Companion.info("Action " + action.getName() + " " + action.getActionId() + " Initializing Completed", "action.initializing.completed", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName())))) : completedAction.copyUpdatingProgress(Status.FAIL);
    }

    @Override
    @NotNull
    public <T extends Action<T>> T execManual(@NotNull T action, @NotNull Function1<? super T, ? extends T> actionLogic) {
        boolean bl;
        Action completedAction;
        block8: {
            Action action2;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
            T processingAction = action.copyUpdatingProgress(Status.PROCESSING, Message.Companion.info("Action " + action.getName() + " " + action.getActionId() + " Processing", "action.processing", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName()))));
            try {
                T t;
                this.verifyInit((Action<?>)processingAction);
                if (processingAction instanceof MultiSourceAction && this.getLinkService().needsExpanding(((MultiSourceAction)processingAction).getSource())) {
                    Object t2 = ((MultiSourceAction)processingAction).copyWithSource(this.getLinkService().expand(((MultiSourceAction)processingAction).getSource()));
                    Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type org.kuali.research.pdf.action.Action<T of org.kuali.research.pdf.action.ActionHelperServiceImpl.execManual>");
                    t = ((Action)t2).copyUpdatingProgress(Status.PROCESSING, Message.Companion.info("Action " + processingAction.getName() + " " + processingAction.getActionId() + " Expanding Links", "source.expanding.links", MapsKt.mapOf(Props.ACTION_NAME.pair(processingAction.getName()))));
                } else {
                    t = processingAction;
                }
                action2 = (Action)actionLogic.invoke(t);
            }
            catch (Exception e) {
                this.getLogger().error((CharSequence)("Action " + action.getName() + " " + action.getActionId() + " processing failed"), (Throwable)e);
                String string = e.getMessage();
                if (string == null) {
                    string = "unknown";
                }
                return processingAction.copyUpdatingProgress(Status.FAIL, Message.Companion.error(string, "unknown.error", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName()))));
            }
            completedAction = action2;
            Iterable $this$any$iv = ((Messages)completedAction).getMessages();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message m = (Message)element$iv;
                    boolean bl2 = false;
                    if (!(m.getLevel() == Level.FATAL || m.getLevel() == Level.ERROR)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean failedMessages = bl;
        return !failedMessages ? completedAction.copyUpdatingProgress(Status.SUCCESS, Message.Companion.info("Action " + action.getName() + " " + action.getActionId() + " Processing Completed", "action.processing.completed", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName())))) : completedAction.copyUpdatingProgress(Status.FAIL);
    }

    @Override
    @NotNull
    public <T extends Action<T>> T finalizeManual(@NotNull T action, @NotNull Function1<? super T, ? extends T> actionLogic) {
        boolean bl;
        Action completedAction;
        block6: {
            Action action2;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
            T processingAction = action.copyUpdatingProgress(Status.FINALIZING, Message.Companion.info("Action " + action.getName() + " " + action.getActionId() + " Finalizing", "action.finalizing", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName()))));
            try {
                this.verifyInit((Action<?>)processingAction);
                action2 = (Action)actionLogic.invoke(processingAction);
            }
            catch (Exception e) {
                this.getLogger().error((CharSequence)("Action " + action.getName() + " " + action.getActionId() + " finalization failed"), (Throwable)e);
                String string = e.getMessage();
                if (string == null) {
                    string = "unknown";
                }
                return processingAction.copyUpdatingProgress(Status.FAIL, Message.Companion.error(string, "unknown.error", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName()))));
            }
            completedAction = action2;
            Iterable $this$any$iv = ((Messages)completedAction).getMessages();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message m = (Message)element$iv;
                    boolean bl2 = false;
                    if (!(m.getLevel() == Level.FATAL || m.getLevel() == Level.ERROR)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean failedMessages = bl;
        return !failedMessages ? completedAction.copyUpdatingProgress(Status.SUCCESS, Message.Companion.info("Action " + action.getName() + " " + action.getActionId() + " Finalization Completed", "action.finalization.completed", MapsKt.mapOf(Props.ACTION_NAME.pair(action.getName())))) : completedAction.copyUpdatingProgress(Status.FAIL);
    }

    @Override
    @NotNull
    public <T extends Action<T> & SingleSourceAction<T>> T initOneToOne(@NotNull T action, @NotNull Function1<? super T, ? extends T> actionLogic) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
        return this.initManual(action, arg_0 -> ActionHelperServiceImpl.initOneToOne$lambda$0(this, actionLogic, arg_0));
    }

    @Override
    @NotNull
    public <T extends Action<T> & SingleSourceAction<T>> T execOneToOne(@NotNull T action, @NotNull Function2<? super T, ? super PdfDocument, ? extends T> actionLogic) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
        return this.execManual(action, arg_0 -> ActionHelperServiceImpl.execOneToOne$lambda$0(this, action, actionLogic, arg_0));
    }

    @Override
    @NotNull
    public <T extends Action<T> & SingleSourceAction<T>> T finalizeOneToOne(@NotNull T action, @NotNull Function1<? super T, ? extends T> actionLogic) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
        return this.finalizeManual(action, arg_0 -> ActionHelperServiceImpl.finalizeOneToOne$lambda$0(this, actionLogic, arg_0));
    }

    @Override
    @NotNull
    public <T extends Action<T> & SingleSourceAction<T>> T initOneToUnit(@NotNull T action, @NotNull Function1<? super T, ? extends T> actionLogic) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
        return this.initManual(action, arg_0 -> ActionHelperServiceImpl.initOneToUnit$lambda$0(this, actionLogic, arg_0));
    }

    @Override
    @NotNull
    public <T extends Action<T> & SingleSourceAction<T>> T execOneToUnit(@NotNull T action, @NotNull Function2<? super T, ? super PdfDocument, ? extends T> actionLogic) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
        return this.execManual(action, arg_0 -> ActionHelperServiceImpl.execOneToUnit$lambda$0(this, action, actionLogic, arg_0));
    }

    @Override
    @NotNull
    public <T extends Action<T> & SingleSourceAction<T>> T finalizeOneToUnit(@NotNull T action, @NotNull Function1<? super T, ? extends T> actionLogic) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(actionLogic, (String)"actionLogic");
        return this.finalizeManual(action, arg_0 -> ActionHelperServiceImpl.finalizeOneToUnit$lambda$0(this, actionLogic, arg_0));
    }

    private void verifyInit(Action<?> action) {
        Intrinsics.checkNotNull((Object)action.getJobId());
        Intrinsics.checkNotNull((Object)action.getActionId());
    }

    @Override
    @NotNull
    public StampingProperties getDocumentProperties(@NotNull Action<?> action) {
        Map<String, Object> customProperties;
        StampingProperties stampingProperties;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        StampingProperties $this$getDocumentProperties_u24lambda_u240 = stampingProperties = new StampingProperties();
        boolean bl = false;
        String string = action.getJobId();
        Intrinsics.checkNotNull((Object)string);
        String string2 = action.getActionId();
        Intrinsics.checkNotNull((Object)string2);
        $this$getDocumentProperties_u24lambda_u240.setEventCountingMetaInfo((IMetaInfo)new RequestMetaData(string, string2, MapsKt.emptyMap()));
        if (action instanceof CustomSettingsAction && Intrinsics.areEqual((Object)(customProperties = ((CustomSettingsAction)((Object)action)).getCustomSettings()).get("useAppendMode"), (Object)true)) {
            $this$getDocumentProperties_u24lambda_u240.useAppendMode();
        }
        return stampingProperties;
    }

    private static final Action initOneToOne$lambda$0(ActionHelperServiceImpl this$0, Function1 $actionLogic, Action executingAction) {
        Link link;
        Link source;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        if (((SingleSourceAction)((Object)executingAction)).getSource() instanceof ActionLink) {
            ActionLinkInitFinalizeService actionLinkInitFinalizeService = this$0.getActionLinkInitFinalizeService();
            Link link2 = ((SingleSourceAction)((Object)executingAction)).getSource();
            Intrinsics.checkNotNull((Object)link2, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.ActionLink");
            v2 = actionLinkInitFinalizeService.init((ActionLink)link2, executingAction);
        } else {
            v2 = source = ((SingleSourceAction)((Object)executingAction)).getSource();
        }
        if (((SingleTargetAction)((Object)executingAction)).getTarget() instanceof ActionLink) {
            ActionLinkInitFinalizeService actionLinkInitFinalizeService = this$0.getActionLinkInitFinalizeService();
            Link link3 = ((SingleTargetAction)((Object)executingAction)).getTarget();
            Intrinsics.checkNotNull((Object)link3, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.ActionLink");
            link = actionLinkInitFinalizeService.init((ActionLink)link3, executingAction);
        } else {
            link = ((SingleTargetAction)((Object)executingAction)).getTarget();
        }
        Link target = link;
        return (Action)$actionLogic.invoke(((SingleTargetAction)((SingleSourceAction)((Object)executingAction)).copyWithSource(source)).copyWithTarget(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Action execOneToOne$lambda$0(ActionHelperServiceImpl this$0, Action $action, Function2 $actionLogic, Action executingAction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        try {
            Action action;
            object = (Closeable)new PdfReader(this$0.getLinkService().input(((SingleSourceAction)((Object)$action)).getSource()));
            Throwable throwable = null;
            try {
                Action action2;
                PdfReader reader = (PdfReader)object;
                boolean bl = false;
                LinkService linkService = this$0.getLinkService();
                Link link = ((SingleTargetAction)((Object)executingAction)).getTarget();
                String string = ((JobAware)executingAction).getJobId();
                Intrinsics.checkNotNull((Object)string);
                String string2 = executingAction.getActionId();
                Intrinsics.checkNotNull((Object)string2);
                Link resolvedTarget = linkService.newIfNull(link, string, string2, "0");
                Closeable closeable = (Closeable)new PdfWriter(this$0.getLinkService().output(resolvedTarget));
                Throwable throwable2 = null;
                try {
                    Action action3;
                    PdfWriter writer = (PdfWriter)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = (Closeable)new PdfDocument(reader, writer, this$0.getDocumentProperties($action));
                    Throwable throwable3 = null;
                    try {
                        PdfDocument document = (PdfDocument)closeable2;
                        boolean bl3 = false;
                        action3 = reader.isEncrypted() ? $action.copyUpdatingProgress(Status.FAIL, Message.Companion.error("The source pdf is encrypted.", "source.encrypted", MapsKt.mapOf(Props.ACTION_NAME.pair($action.getName())))) : (Action)$actionLogic.invoke(((SingleTargetAction)((Object)executingAction)).copyWithTarget(resolvedTarget), (Object)document);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    }
                    action2 = action3;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                action = action2;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = action;
        }
        catch (BadPasswordException e) {
            this$0.getLogger().debug((Object)e);
            object = $action.copyUpdatingProgress(Status.FAIL, Message.Companion.error("The source pdf is encrypted.", "source.encrypted", MapsKt.mapOf(Props.ACTION_NAME.pair($action.getName()))));
        }
        return object;
    }

    private static final Action finalizeOneToOne$lambda$0(ActionHelperServiceImpl this$0, Function1 $actionLogic, Action executingAction) {
        Link link;
        Link source;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        if (((SingleSourceAction)((Object)executingAction)).getSource() instanceof ActionLink) {
            ActionLinkInitFinalizeService actionLinkInitFinalizeService = this$0.getActionLinkInitFinalizeService();
            Link link2 = ((SingleSourceAction)((Object)executingAction)).getSource();
            Intrinsics.checkNotNull((Object)link2, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.ActionLink");
            v2 = actionLinkInitFinalizeService.finalize((ActionLink)link2, executingAction);
        } else {
            v2 = source = ((SingleSourceAction)((Object)executingAction)).getSource();
        }
        if (((SingleTargetAction)((Object)executingAction)).getTarget() instanceof ActionLink) {
            ActionLinkInitFinalizeService actionLinkInitFinalizeService = this$0.getActionLinkInitFinalizeService();
            Link link3 = ((SingleTargetAction)((Object)executingAction)).getTarget();
            Intrinsics.checkNotNull((Object)link3, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.ActionLink");
            link = actionLinkInitFinalizeService.finalize((ActionLink)link3, executingAction);
        } else {
            link = ((SingleTargetAction)((Object)executingAction)).getTarget();
        }
        Link target = link;
        return (Action)$actionLogic.invoke(((SingleTargetAction)((SingleSourceAction)((Object)executingAction)).copyWithSource(source)).copyWithTarget(target));
    }

    private static final Action initOneToUnit$lambda$0(ActionHelperServiceImpl this$0, Function1 $actionLogic, Action executingAction) {
        Link link;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        if (((SingleSourceAction)((Object)executingAction)).getSource() instanceof ActionLink) {
            ActionLinkInitFinalizeService actionLinkInitFinalizeService = this$0.getActionLinkInitFinalizeService();
            Link link2 = ((SingleSourceAction)((Object)executingAction)).getSource();
            Intrinsics.checkNotNull((Object)link2, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.ActionLink");
            link = actionLinkInitFinalizeService.init((ActionLink)link2, executingAction);
        } else {
            link = ((SingleSourceAction)((Object)executingAction)).getSource();
        }
        Link source = link;
        return (Action)$actionLogic.invoke(((SingleSourceAction)((Object)executingAction)).copyWithSource(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Action execOneToUnit$lambda$0(ActionHelperServiceImpl this$0, Action $action, Function2 $actionLogic, Action executingAction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        try {
            Action action;
            object = (Closeable)new PdfReader(this$0.getLinkService().input(((SingleSourceAction)((Object)$action)).getSource()));
            Throwable throwable = null;
            try {
                Action action2;
                PdfReader reader = (PdfReader)object;
                boolean bl = false;
                Closeable closeable = (Closeable)new PdfDocument(reader, (DocumentProperties)this$0.getDocumentProperties($action));
                Throwable throwable2 = null;
                try {
                    PdfDocument document = (PdfDocument)closeable;
                    boolean bl2 = false;
                    action2 = reader.isEncrypted() ? $action.copyUpdatingProgress(Status.FAIL, Message.Companion.error("The source pdf is encrypted.", "source.encrypted", MapsKt.mapOf(Props.ACTION_NAME.pair($action.getName())))) : (Action)$actionLogic.invoke((Object)executingAction, (Object)document);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                action = action2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = action;
        }
        catch (BadPasswordException e) {
            this$0.getLogger().debug((Object)e);
            object = $action.copyUpdatingProgress(Status.FAIL, Message.Companion.error("The source pdf is encrypted.", "source.encrypted", MapsKt.mapOf(Props.ACTION_NAME.pair($action.getName()))));
        }
        return object;
    }

    private static final Action finalizeOneToUnit$lambda$0(ActionHelperServiceImpl this$0, Function1 $actionLogic, Action executingAction) {
        Link link;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        if (((SingleSourceAction)((Object)executingAction)).getSource() instanceof ActionLink) {
            ActionLinkInitFinalizeService actionLinkInitFinalizeService = this$0.getActionLinkInitFinalizeService();
            Link link2 = ((SingleSourceAction)((Object)executingAction)).getSource();
            Intrinsics.checkNotNull((Object)link2, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.ActionLink");
            link = actionLinkInitFinalizeService.finalize((ActionLink)link2, executingAction);
        } else {
            link = ((SingleSourceAction)((Object)executingAction)).getSource();
        }
        Link source = link;
        return (Action)$actionLogic.invoke(((SingleSourceAction)((Object)executingAction)).copyWithSource(source));
    }
}

