/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.link;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.link.ActionLinkService;
import org.kuali.research.pdf.link.ClasspathLink;
import org.kuali.research.pdf.link.FileLink;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkServiceImpl;
import org.kuali.research.pdf.sys.model.PdfException;
import org.kuali.research.pdf.sys.model.Props;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"allow.file.links"})
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kuali/research/pdf/link/LinkServiceWithFileClassPathLinkSupportImpl;", "Lorg/kuali/research/pdf/link/LinkServiceImpl;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "actionLinkService", "Lorg/kuali/research/pdf/link/ActionLinkService;", "<init>", "(Lorg/springframework/web/client/RestTemplate;Lorg/kuali/research/pdf/link/ActionLinkService;)V", "input", "Ljava/io/InputStream;", "link", "Lorg/kuali/research/pdf/link/Link;", "output", "Ljava/io/OutputStream;", "pdf"})
public class LinkServiceWithFileClassPathLinkSupportImpl
extends LinkServiceImpl {
    public LinkServiceWithFileClassPathLinkSupportImpl(@Autowired @NotNull RestTemplate restTemplate, @Autowired @NotNull ActionLinkService actionLinkService) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)actionLinkService, (String)"actionLinkService");
        super(restTemplate, actionLinkService);
    }

    @Override
    @NotNull
    public InputStream input(@NotNull Link link) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Link link2 = link;
        if (link2 instanceof FileLink) {
            inputStream = new FileInputStream(new File(new URI(((FileLink)link).getUrl())));
        } else if (link2 instanceof ClasspathLink) {
            InputStream inputStream2 = new ClassPathResource(StringsKt.removePrefix((String)((ClasspathLink)link).getUrl(), (CharSequence)(link.protocol() + ":"))).getInputStream();
            inputStream = inputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        } else {
            inputStream = super.input(link);
        }
        return inputStream;
    }

    @Override
    @NotNull
    public OutputStream output(@NotNull Link link) {
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Link link2 = link;
        if (link2 instanceof FileLink) {
            outputStream = new FileOutputStream(new File(new URI(((FileLink)link).getUrl())));
        } else {
            if (link2 instanceof ClasspathLink) {
                String string = link.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                throw new PdfException("link.type.read.only", MapsKt.mapOf(Props.LINK_TYPE.pair(string)), "link type " + link + " is read only", null, 8, null);
            }
            outputStream = super.output(link);
        }
        return outputStream;
    }
}

