/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.env;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.env.Env;
import org.kuali.research.pdf.sys.env.EnvService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@ConditionalOnProperty(name={"env.aware.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B5\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0015H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kuali/research/pdf/sys/env/HeaderBasedEnvFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "envService", "Lorg/kuali/research/pdf/sys/env/EnvService;", "tenantHeaderName", "", "laneHeaderName", "excludedUrls", "", "<init>", "(Lorg/kuali/research/pdf/sys/env/EnvService;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getEnvService", "()Lorg/kuali/research/pdf/sys/env/EnvService;", "getTenantHeaderName", "()Ljava/lang/String;", "getLaneHeaderName", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "verifyHeaderName", "pdf"})
@SourceDebugExtension(value={"SMAP\nEnvAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvAware.kt\norg/kuali/research/pdf/sys/env/HeaderBasedEnvFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1761#2,3:88\n1#3:91\n*S KotlinDebug\n*F\n+ 1 EnvAware.kt\norg/kuali/research/pdf/sys/env/HeaderBasedEnvFilter\n*L\n41#1:88,3\n*E\n"})
public class HeaderBasedEnvFilter
extends OncePerRequestFilter {
    @NotNull
    private final EnvService envService;
    @NotNull
    private final String tenantHeaderName;
    @NotNull
    private final String laneHeaderName;
    @NotNull
    private final Set<String> excludedUrls;

    public HeaderBasedEnvFilter(@Autowired @NotNull EnvService envService, @Value(value="${env.aware.tenant.header.name:}") @NotNull String tenantHeaderName, @Value(value="${env.aware.lane.header.name:}") @NotNull String laneHeaderName, @Value(value="${env.aware.excludedUrls:/pdf/actuator/health,/pdf/swagger/.*,/pdf/webjars/.*}") @NotNull Set<String> excludedUrls) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        Intrinsics.checkNotNullParameter((Object)tenantHeaderName, (String)"tenantHeaderName");
        Intrinsics.checkNotNullParameter((Object)laneHeaderName, (String)"laneHeaderName");
        Intrinsics.checkNotNullParameter(excludedUrls, (String)"excludedUrls");
        this.envService = envService;
        this.tenantHeaderName = tenantHeaderName;
        this.laneHeaderName = laneHeaderName;
        this.excludedUrls = excludedUrls;
    }

    @NotNull
    public EnvService getEnvService() {
        return this.envService;
    }

    @NotNull
    public String getTenantHeaderName() {
        return this.tenantHeaderName;
    }

    @NotNull
    public String getLaneHeaderName() {
        return this.laneHeaderName;
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.excludedUrls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    CharSequence charSequence = string;
                    if (!new Regex(it).matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        String tenant = request.getHeader(this.getTenantHeaderName());
        String lane = request.getHeader(this.getLaneHeaderName());
        CharSequence charSequence = tenant;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)lane) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            response.sendError(HttpStatus.BAD_REQUEST.value(), "Request Headers are required [" + this.getTenantHeaderName() + ", " + this.getLaneHeaderName() + "]");
        } else {
            try {
                this.getEnvService().getEnv().set(new Env(tenant, lane));
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                this.getEnvService().getEnv().remove();
            }
        }
    }

    @PostConstruct
    public void verifyHeaderName() {
        if (!(!StringsKt.isBlank((CharSequence)this.getTenantHeaderName()))) {
            boolean $i$a$-check-HeaderBasedEnvFilter$verifyHeaderName$32 = false;
            String $i$a$-check-HeaderBasedEnvFilter$verifyHeaderName$32 = "tenantHeaderName is blank";
            throw new IllegalStateException($i$a$-check-HeaderBasedEnvFilter$verifyHeaderName$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.getLaneHeaderName()))) {
            boolean bl = false;
            String string = "laneHeaderName is blank";
            throw new IllegalStateException(string.toString());
        }
    }
}

