/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import jakarta.annotation.PreDestroy;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.mongo.TenancyMongoClientDatabaseFactory;
import org.kuali.research.pdf.sys.tenancy.TenancyService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.mongo.MongoClientFactory;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoDatabaseFactorySupport;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
@EnableConfigurationProperties(value={MongoProperties.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\rH\u0017J,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/kuali/research/pdf/sys/mongo/MongoDataConfiguration;", "", "<init>", "()V", "mongoClient", "Lcom/mongodb/client/MongoClient;", "mongo", "builderCustomizers", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/boot/autoconfigure/mongo/MongoClientSettingsBuilderCustomizer;", "settings", "Lcom/mongodb/MongoClientSettings;", "close", "", "tenancyMongoDbFactory", "Lorg/springframework/data/mongodb/core/MongoDatabaseFactorySupport;", "mongoProperties", "Lorg/springframework/boot/autoconfigure/mongo/MongoProperties;", "tenancyService", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService;", "dotReplacementMappingMongoConverter", "Lorg/springframework/data/mongodb/core/convert/MappingMongoConverter;", "factory", "Lorg/springframework/data/mongodb/MongoDatabaseFactory;", "context", "Lorg/springframework/data/mongodb/core/mapping/MongoMappingContext;", "conversions", "Lorg/springframework/data/mongodb/core/convert/MongoCustomConversions;", "MongoClientSettingsConfiguration", "pdf"})
public class MongoDataConfiguration {
    private MongoClient mongoClient;

    @Bean
    @NotNull
    public MongoClient mongo(@NotNull ObjectProvider<MongoClientSettingsBuilderCustomizer> builderCustomizers, @NotNull MongoClientSettings settings) {
        Intrinsics.checkNotNullParameter(builderCustomizers, (String)"builderCustomizers");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Object object = new MongoClientFactory(builderCustomizers.orderedStream().collect(Collectors.toList())).createMongoClient(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createMongoClient(...)");
        this.mongoClient = (MongoClient)object;
        MongoClient mongoClient = this.mongoClient;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongoClient");
            mongoClient = null;
        }
        return mongoClient;
    }

    @PreDestroy
    public void close() {
        MongoClient mongoClient = this.mongoClient;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongoClient");
            mongoClient = null;
        }
        mongoClient.close();
    }

    @Bean
    @NotNull
    public MongoDatabaseFactorySupport<MongoClient> tenancyMongoDbFactory(@NotNull ObjectProvider<MongoClient> mongoClient, @NotNull MongoProperties mongoProperties, @NotNull TenancyService tenancyService) {
        Intrinsics.checkNotNullParameter(mongoClient, (String)"mongoClient");
        Intrinsics.checkNotNullParameter((Object)mongoProperties, (String)"mongoProperties");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        MongoClient client = (MongoClient)mongoClient.getIfAvailable();
        if (client != null) {
            String string = mongoProperties.getMongoClientDatabase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMongoClientDatabase(...)");
            return (MongoDatabaseFactorySupport)new TenancyMongoClientDatabaseFactory(tenancyService, client, string);
        }
        throw new IllegalStateException("Expected to find at least one MongoDB client.");
    }

    @Bean
    @NotNull
    public MappingMongoConverter dotReplacementMappingMongoConverter(@NotNull MongoDatabaseFactory factory, @NotNull MongoMappingContext context, @NotNull MongoCustomConversions conversions) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conversions, (String)"conversions");
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
        mappingConverter.setCustomConversions((CustomConversions)conversions);
        mappingConverter.setMapKeyDotReplacement("-_dot_-");
        return mappingConverter;
    }
}

