/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.authnintegration.sp.internal.service;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.authnintegration.sp.ResSpAuthnUser;
import org.kuali.research.pdf.authnintegration.sp.SpAuthnBearerToken;
import org.kuali.research.pdf.authnintegration.sp.internal.service.ResSpMutableAuthnService;
import org.kuali.research.pdf.sys.jwt.JwtService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001dB#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010\u0019\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0012J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u000f\u0010\u001b\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/kuali/research/pdf/authnintegration/sp/internal/service/ResSpMutableAuthnServiceImpl;", "Lorg/kuali/research/pdf/authnintegration/sp/internal/service/ResSpMutableAuthnService;", "spSystemToSystemSecret", "", "spSystemToSystemExpirationSeconds", "", "jwtService", "Lorg/kuali/research/pdf/sys/jwt/JwtService;", "<init>", "(Ljava/lang/String;JLorg/kuali/research/pdf/sys/jwt/JwtService;)V", "getSpSystemToSystemSecret", "()Ljava/lang/String;", "getSpSystemToSystemExpirationSeconds", "()J", "getJwtService", "()Lorg/kuali/research/pdf/sys/jwt/JwtService;", "isSet", "", "authnUser", "Lkotlin/Pair;", "Lorg/kuali/research/pdf/authnintegration/sp/SpAuthnBearerToken;", "Lorg/kuali/research/pdf/authnintegration/sp/ResSpAuthnUser;", "setAuthnUser", "", "resSpAuthnUser", "setAuthnUserUnsafe", "removeAuthnUser", "system2SystemToken", "system2SystemToken-7-ldTfY", "AuthnUserState", "pdf"})
public class ResSpMutableAuthnServiceImpl
implements ResSpMutableAuthnService {
    @NotNull
    private final String spSystemToSystemSecret;
    private final long spSystemToSystemExpirationSeconds;
    @NotNull
    private final JwtService jwtService;

    public ResSpMutableAuthnServiceImpl(@Value(value="${kuali.sp.authn.service2service.secret}") @NotNull String spSystemToSystemSecret, @Value(value="${kuali.sp.authn.service2service.expiration.seconds}") long spSystemToSystemExpirationSeconds, @NotNull JwtService jwtService) {
        Intrinsics.checkNotNullParameter((Object)spSystemToSystemSecret, (String)"spSystemToSystemSecret");
        Intrinsics.checkNotNullParameter((Object)jwtService, (String)"jwtService");
        this.spSystemToSystemSecret = spSystemToSystemSecret;
        this.spSystemToSystemExpirationSeconds = spSystemToSystemExpirationSeconds;
        this.jwtService = jwtService;
    }

    @NotNull
    public String getSpSystemToSystemSecret() {
        return this.spSystemToSystemSecret;
    }

    public long getSpSystemToSystemExpirationSeconds() {
        return this.spSystemToSystemExpirationSeconds;
    }

    @NotNull
    public JwtService getJwtService() {
        return this.jwtService;
    }

    @Override
    public boolean isSet() {
        return AuthnUserState.INSTANCE.getResSpAuthnUsers().get() != null;
    }

    @Override
    @NotNull
    public Pair<SpAuthnBearerToken, ResSpAuthnUser> authnUser() {
        Pair pair = (Pair)AuthnUserState.INSTANCE.getResSpAuthnUsers().get();
        if (pair == null) {
            throw new IllegalStateException("authn user not set");
        }
        return pair;
    }

    @Override
    public void setAuthnUser(@NotNull Pair<SpAuthnBearerToken, ResSpAuthnUser> resSpAuthnUser) {
        Intrinsics.checkNotNullParameter(resSpAuthnUser, (String)"resSpAuthnUser");
        this.setAuthnUserUnsafe(resSpAuthnUser);
    }

    private void setAuthnUserUnsafe(Pair<SpAuthnBearerToken, ResSpAuthnUser> resSpAuthnUser) {
        AuthnUserState.INSTANCE.getResSpAuthnUsers().set(resSpAuthnUser);
    }

    @Override
    public void removeAuthnUser() {
        AuthnUserState.INSTANCE.getResSpAuthnUsers().remove();
    }

    @Override
    @NotNull
    public String system2SystemToken-7-ldTfY() {
        return SpAuthnBearerToken.constructor-impl(this.getJwtService().createToken(this.getSpSystemToSystemSecret(), this.getSpSystemToSystemExpirationSeconds()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/kuali/research/pdf/authnintegration/sp/internal/service/ResSpMutableAuthnServiceImpl$AuthnUserState;", "", "<init>", "()V", "resSpAuthnUsers", "Ljava/lang/InheritableThreadLocal;", "Lkotlin/Pair;", "Lorg/kuali/research/pdf/authnintegration/sp/SpAuthnBearerToken;", "Lorg/kuali/research/pdf/authnintegration/sp/ResSpAuthnUser;", "getResSpAuthnUsers", "()Ljava/lang/InheritableThreadLocal;", "pdf"})
    public static final class AuthnUserState {
        @NotNull
        public static final AuthnUserState INSTANCE = new AuthnUserState();
        @NotNull
        private static final InheritableThreadLocal<Pair<SpAuthnBearerToken, ResSpAuthnUser>> resSpAuthnUsers = new InheritableThreadLocal();

        private AuthnUserState() {
        }

        @NotNull
        public final InheritableThreadLocal<Pair<SpAuthnBearerToken, ResSpAuthnUser>> getResSpAuthnUsers() {
            return resSpAuthnUsers;
        }
    }
}

