/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.link.fs;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.ActionLinkService;
import org.kuali.research.pdf.link.FileLink;
import org.kuali.research.pdf.link.Link;
import org.owasp.fileio.SafeFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"aws.s3.enabled"}, havingValue="false", matchIfMissing=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/kuali/research/pdf/link/fs/ActionLinkFinalizeServiceFileSystemImpl;", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "actionLinkService", "Lorg/kuali/research/pdf/link/ActionLinkService;", "<init>", "(Lorg/kuali/research/pdf/link/ActionLinkService;)V", "getActionLinkService", "()Lorg/kuali/research/pdf/link/ActionLinkService;", "init", "Lorg/kuali/research/pdf/link/Link;", "link", "Lorg/kuali/research/pdf/link/ActionLink;", "action", "Lorg/kuali/research/pdf/action/Action;", "finalize", "pdf"})
public class ActionLinkFinalizeServiceFileSystemImpl
implements ActionLinkInitFinalizeService {
    @NotNull
    private final ActionLinkService actionLinkService;

    public ActionLinkFinalizeServiceFileSystemImpl(@Autowired @NotNull ActionLinkService actionLinkService) {
        Intrinsics.checkNotNullParameter((Object)actionLinkService, (String)"actionLinkService");
        this.actionLinkService = actionLinkService;
    }

    @NotNull
    public ActionLinkService getActionLinkService() {
        return this.actionLinkService;
    }

    @Override
    @NotNull
    public Link init(@NotNull ActionLink link, @NotNull Action<?> action) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String protocol = link.protocol();
        String path = StringsKt.removePrefix((String)link.getUrl(), (CharSequence)(protocol + "://"));
        return link.copy(protocol + "://" + action.getJobId() + "/" + StringsKt.substringAfter$default((String)path, (String)"/", null, (int)2, null));
    }

    @Override
    @NotNull
    public Link finalize(@NotNull ActionLink link, @NotNull Action<?> action) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        SafeFile file = this.getActionLinkService().toFile(link);
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new FileLink("file:///" + StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null));
    }
}

