/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.cache;

import com.github.benmanes.caffeine.cache.CaffeineSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.cache.CaffeineCacheProperties;
import org.kuali.research.pdf.sys.cache.DelegatingCacheManager;
import org.kuali.research.pdf.sys.cache.NoOpCacheManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={CaffeineCacheProperties.class})
@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/kuali/research/pdf/sys/cache/CaffeineCacheConfiguration;", "", "caffeineCacheProperties", "Lorg/kuali/research/pdf/sys/cache/CaffeineCacheProperties;", "<init>", "(Lorg/kuali/research/pdf/sys/cache/CaffeineCacheProperties;)V", "getCaffeineCacheProperties", "()Lorg/kuali/research/pdf/sys/cache/CaffeineCacheProperties;", "caffeineCacheManager", "Lorg/springframework/cache/CacheManager;", "noOpCacheManager", "pdf"})
@SourceDebugExtension(value={"SMAP\nCaffeineCacheConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaffeineCacheConfiguration.kt\norg/kuali/research/pdf/sys/cache/CaffeineCacheConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,79:1\n827#2:80\n855#2,2:81\n1285#2,2:83\n1299#2,4:85\n1252#2,4:91\n1504#2:95\n1534#2,3:96\n1537#2,3:106\n463#3:89\n413#3:90\n382#3,7:99\n126#4:109\n153#4,3:110\n*S KotlinDebug\n*F\n+ 1 CaffeineCacheConfiguration.kt\norg/kuali/research/pdf/sys/cache/CaffeineCacheConfiguration\n*L\n34#1:80\n34#1:81,2\n37#1:83,2\n37#1:85,4\n43#1:91,4\n45#1:95\n45#1:96,3\n45#1:106,3\n43#1:89\n43#1:90\n45#1:99,7\n46#1:109\n46#1:110,3\n*E\n"})
public class CaffeineCacheConfiguration {
    @NotNull
    private final CaffeineCacheProperties caffeineCacheProperties;

    public CaffeineCacheConfiguration(@NotNull CaffeineCacheProperties caffeineCacheProperties) {
        Intrinsics.checkNotNullParameter((Object)caffeineCacheProperties, (String)"caffeineCacheProperties");
        this.caffeineCacheProperties = caffeineCacheProperties;
    }

    @NotNull
    public CaffeineCacheProperties getCaffeineCacheProperties() {
        return this.caffeineCacheProperties;
    }

    /*
     * WARNING - void declaration
     */
    @ConditionalOnProperty(name={"spring.cache.enabled"})
    @Bean
    @NotNull
    public CacheManager caffeineCacheManager() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Map map;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Iterable $this$mapValues$iv;
        String string;
        Object object;
        Object object2;
        Object element$iv$iv3;
        void $this$associateWithTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.getCaffeineCacheProperties().getCacheNames();
        boolean $i$f$filterNot = false;
        Iterable iterable2 = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
            String cacheName = (String)element$iv$iv2;
            boolean bl = false;
            if (this.getCaffeineCacheProperties().getCaffeine().getSpecOverride().keySet().contains(cacheName)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv3 : $this$associateWithTo$iv$iv) {
            String bl = (String)element$iv$iv3;
            object2 = element$iv$iv3;
            object = destination$iv$iv2;
            boolean bl2 = false;
            string = this.getCaffeineCacheProperties().getCaffeine().getSpec();
            object.put(object2, string);
        }
        Map defaultSpecs = destination$iv$iv2;
        Map<String, String> overriddenSpecs = this.getCaffeineCacheProperties().getCaffeine().getSpecOverride();
        result$iv = MapsKt.plus((Map)defaultSpecs, overriddenSpecs);
        boolean $i$f$mapValues = false;
        destination$iv$iv2 = $this$mapValues$iv;
        Object destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        element$iv$iv3 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv3;
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object = map;
            boolean bl3 = false;
            String v = (String)entry2.getValue();
            string = !StringsKt.isBlank((CharSequence)v) ? CaffeineSpec.parse((String)v) : null;
            object.put(object2, string);
        }
        $this$mapValues$iv = destination$iv$iv$iv.entrySet();
        boolean $i$f$groupBy = false;
        $this$mapValuesTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv4 : $this$groupByTo$iv$iv) {
            Object object3;
            void $this$getOrPut$iv$iv$iv;
            CaffeineSpec v;
            Map.Entry $i$f$associateByTo2 = (Map.Entry)element$iv$iv4;
            boolean $i$a$-groupBy-CaffeineCacheConfiguration$caffeineCacheManager$cacheManagers$42 = false;
            CaffeineSpec key$iv$iv = v = (CaffeineSpec)$i$f$associateByTo2.getValue();
            map = destination$iv$iv3;
            CaffeineSpec key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            Map.Entry $i$a$-groupBy-CaffeineCacheConfiguration$caffeineCacheManager$cacheManagers$42 = (Map.Entry)element$iv$iv4;
            object = list$iv$iv;
            boolean bl = false;
            String k = (String)$i$a$-groupBy-CaffeineCacheConfiguration$caffeineCacheManager$cacheManagers$42.getKey();
            object.add(k);
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            object = destination$iv$iv3;
            boolean bl = false;
            CaffeineSpec spec = (CaffeineSpec)entry.getKey();
            List cacheNames = (List)entry.getValue();
            CaffeineCacheManager cm = new CaffeineCacheManager();
            if (spec != null) {
                cm.setCaffeineSpec(spec);
            }
            cm.setCacheNames((Collection)cacheNames);
            object.add(cm);
        }
        List cacheManagers = (List)destination$iv$iv3;
        return new DelegatingCacheManager(cacheManagers);
    }

    @ConditionalOnProperty(name={"spring.cache.enabled"}, havingValue="false", matchIfMissing=true)
    @Bean
    @NotNull
    public CacheManager noOpCacheManager() {
        return new NoOpCacheManager((Collection<String>)this.getCaffeineCacheProperties().getCacheNames());
    }
}

