/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.mongo;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.health.HealthConstants;
import org.kuali.research.pdf.sys.tenancy.TenancyService;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.mongodb.core.MongoTemplate;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kuali/research/pdf/sys/mongo/CustomMongoHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "tenancyService", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService;", "<init>", "(Lorg/springframework/data/mongodb/core/MongoTemplate;Lorg/kuali/research/pdf/sys/tenancy/TenancyService;)V", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "performMongoHealthCheck", "pdf"})
public final class CustomMongoHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final TenancyService tenancyService;

    public CustomMongoHealthIndicator(@NotNull MongoTemplate mongoTemplate, @NotNull TenancyService tenancyService) {
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        super("MongoDB health check failed");
        this.mongoTemplate = mongoTemplate;
        this.tenancyService = tenancyService;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        try {
            if (this.tenancyService.isSet()) {
                this.performMongoHealthCheck(builder);
            } else {
                this.tenancyService.doInInternal(TenancyService.ExternalSystem.SP, () -> CustomMongoHealthIndicator.doHealthCheck$lambda$0(this, builder));
            }
        }
        catch (Exception e) {
            builder.withException((Throwable)e);
            builder.status(HealthConstants.INSTANCE.getDOWN_NON_FATAL());
        }
    }

    private final void performMongoHealthCheck(Health.Builder builder) {
        Document document = this.mongoTemplate.executeCommand("{ hello: 1 }");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"executeCommand(...)");
        Document result = document;
        builder.up().withDetail("maxWireVersion", (Object)result.getInteger((Object)"maxWireVersion"));
    }

    private static final Unit doHealthCheck$lambda$0(CustomMongoHealthIndicator this$0, Health.Builder $builder) {
        this$0.performMongoHealthCheck($builder);
        return Unit.INSTANCE;
    }
}

