/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.xml.transform;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.ActionService;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.xml.transform.TransformXmlAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/kuali/research/pdf/xml/transform/TransformXmlActionServiceImpl;", "Lorg/kuali/research/pdf/action/ActionService;", "Lorg/kuali/research/pdf/xml/transform/TransformXmlAction;", "Lorg/apache/logging/log4j/kotlin/Logging;", "actionHelperService", "Lorg/kuali/research/pdf/action/ActionHelperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "actionLinkInitFinalizeService", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "<init>", "(Lorg/kuali/research/pdf/action/ActionHelperService;Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;)V", "getActionHelperService", "()Lorg/kuali/research/pdf/action/ActionHelperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getActionLinkInitFinalizeService", "()Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "init", "action", "exec", "finalize", "pdf"})
@SourceDebugExtension(value={"SMAP\nTransformXmlActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformXmlActionServiceImpl.kt\norg/kuali/research/pdf/xml/transform/TransformXmlActionServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public class TransformXmlActionServiceImpl
implements ActionService<TransformXmlAction>,
Logging {
    @NotNull
    private final ActionHelperService actionHelperService;
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final ActionLinkInitFinalizeService actionLinkInitFinalizeService;

    public TransformXmlActionServiceImpl(@Autowired @NotNull ActionHelperService actionHelperService, @Autowired @NotNull LinkService linkService, @Autowired @NotNull ActionLinkInitFinalizeService actionLinkInitFinalizeService) {
        Intrinsics.checkNotNullParameter((Object)actionHelperService, (String)"actionHelperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)actionLinkInitFinalizeService, (String)"actionLinkInitFinalizeService");
        this.actionHelperService = actionHelperService;
        this.linkService = linkService;
        this.actionLinkInitFinalizeService = actionLinkInitFinalizeService;
    }

    @NotNull
    public ActionHelperService getActionHelperService() {
        return this.actionHelperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public ActionLinkInitFinalizeService getActionLinkInitFinalizeService() {
        return this.actionLinkInitFinalizeService;
    }

    @Override
    @NotNull
    public TransformXmlAction init(@NotNull TransformXmlAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (TransformXmlAction)this.getActionHelperService().initOneToOne((Action)action, arg_0 -> TransformXmlActionServiceImpl.init$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public TransformXmlAction exec(@NotNull TransformXmlAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (TransformXmlAction)this.getActionHelperService().execManual((Action)action, arg_0 -> TransformXmlActionServiceImpl.exec$lambda$0(this, action, arg_0));
    }

    @Override
    @NotNull
    public TransformXmlAction finalize(@NotNull TransformXmlAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (TransformXmlAction)this.getActionHelperService().finalizeOneToOne((Action)action, arg_0 -> TransformXmlActionServiceImpl.finalize$lambda$0(this, arg_0));
    }

    private static final TransformXmlAction init$lambda$0(TransformXmlActionServiceImpl this$0, TransformXmlAction executingAction) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link xmlDataSource = executingAction.getXmlDataSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)executingAction.getXmlDataSource(), executingAction) : executingAction.getXmlDataSource();
        return TransformXmlAction.copy$default(executingAction, null, null, xmlDataSource, null, null, null, null, null, null, null, 1019, null);
    }

    private static final TransformXmlAction exec$lambda$0(TransformXmlActionServiceImpl this$0, TransformXmlAction $action, TransformXmlAction executingAction) {
        Object object;
        Transformer transformer;
        Result res;
        Link resolvedTarget;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
                LinkService linkService = this$0.getLinkService();
                Link link = executingAction.getTarget();
                String string = executingAction.getJobId();
                Intrinsics.checkNotNull((Object)string);
                String string2 = executingAction.getActionId();
                Intrinsics.checkNotNull((Object)string2);
                resolvedTarget = linkService.newIfNull(link, string, string2, "0");
                FopFactoryBuilder builder = new FopFactoryBuilder(new URI($action.getBaseUri()));
                FopFactory fopFactory = builder.build();
                FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
                Fop fop = fopFactory.newFop("application/pdf", foUserAgent, this$0.getLinkService().output(resolvedTarget));
                res = new SAXResult(fop.getDefaultHandler());
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Intrinsics.checkNotNullExpressionValue((Object)transformerFactory, (String)"newInstance(...)");
                TransformerFactory transformerFactory2 = transformerFactory;
                transformerFactory2.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                transformerFactory2.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer2 = transformerFactory2.newTransformer(new StreamSource(this$0.getLinkService().input($action.getSource())));
                Intrinsics.checkNotNullExpressionValue((Object)transformer2, (String)"newTransformer(...)");
                transformer = transformer2;
                object = $action.getXmlDataSource();
                if (object == null) break block5;
                Link it = object;
                boolean bl = false;
                InputStream inputStream = this$0.getLinkService().input(it);
                object = inputStream;
                if (inputStream != null) break block6;
            }
            String string = $action.getXmlData();
            if (string != null) {
                String it = string;
                boolean bl = false;
                byte[] byArray = it.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                object = new ByteArrayInputStream(byArray);
            } else {
                object = null;
            }
        }
        Link input = object;
        Source src = new StreamSource((InputStream)((Object)input));
        transformer.transform(src, res);
        return TransformXmlAction.copy$default(executingAction, null, null, null, null, null, null, resolvedTarget, null, null, null, 959, null);
    }

    private static final TransformXmlAction finalize$lambda$0(TransformXmlActionServiceImpl this$0, TransformXmlAction executingAction) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link xfaDataSource = executingAction.getXmlDataSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)executingAction.getXmlDataSource(), executingAction) : executingAction.getXmlDataSource();
        return TransformXmlAction.copy$default(executingAction, null, null, xfaDataSource, null, null, null, null, null, null, null, 1019, null);
    }
}

