/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.authnintegration.internal.config;

import jakarta.servlet.Filter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.authnintegration.internal.filter.ResAuthnFilter;
import org.kuali.research.pdf.authnintegration.platform.ResPlatformAuthnFilterService;
import org.kuali.research.pdf.authnintegration.sp.ResSpAuthnFilterService;
import org.kuali.research.pdf.sys.tenancy.TenancyService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0001\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0017\u00a8\u0006\u0010"}, d2={"Lorg/kuali/research/pdf/authnintegration/internal/config/ResAuthnConfiguration;", "", "<init>", "()V", "resAuthnFilter", "Lorg/springframework/boot/web/servlet/FilterRegistrationBean;", "Lorg/kuali/research/pdf/authnintegration/internal/filter/ResAuthnFilter;", "resSpAuthnFilterService", "Lorg/kuali/research/pdf/authnintegration/sp/ResSpAuthnFilterService;", "resPlatformAuthnFilterService", "Lorg/kuali/research/pdf/authnintegration/platform/ResPlatformAuthnFilterService;", "tenancyService", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService;", "excludedPathPatterns", "", "", "pdf"})
public class ResAuthnConfiguration {
    @Bean
    @NotNull
    public FilterRegistrationBean<ResAuthnFilter> resAuthnFilter(@NotNull ResSpAuthnFilterService resSpAuthnFilterService, @NotNull ResPlatformAuthnFilterService resPlatformAuthnFilterService, @NotNull TenancyService tenancyService, @Value(value="${kuali.authn.excluded.path-patterns}") @NotNull Set<String> excludedPathPatterns) {
        Intrinsics.checkNotNullParameter((Object)resSpAuthnFilterService, (String)"resSpAuthnFilterService");
        Intrinsics.checkNotNullParameter((Object)resPlatformAuthnFilterService, (String)"resPlatformAuthnFilterService");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        Intrinsics.checkNotNullParameter(excludedPathPatterns, (String)"excludedPathPatterns");
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new ResAuthnFilter(resSpAuthnFilterService, resPlatformAuthnFilterService, tenancyService, excludedPathPatterns));
        filterRegistrationBean.setOrder(4);
        return filterRegistrationBean;
    }
}

