/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.tenancy.internal.service;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.ThreadContextElement;
import kotlinx.coroutines.ThreadContextElementKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.tenancy.TenancyService;
import org.kuali.research.pdf.sys.tenancy.internal.service.MutableTenancyService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001aB%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J)\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kuali/research/pdf/sys/tenancy/internal/service/TenancyServiceImpl;", "Lorg/kuali/research/pdf/sys/tenancy/internal/service/MutableTenancyService;", "kualiSpEnvironmentSystem", "", "kualiPlatformEnvironmentSystem", "kualiSpAppName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "isValidTenantHost", "", "host", "isSet", "setTenantHost", "", "removeTenantHost", "getTenantSigil", "doInInternal", "R", "tenantType", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService$ExternalSystem;", "task", "Lkotlin/Function0;", "(Lorg/kuali/research/pdf/sys/tenancy/TenancyService$ExternalSystem;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "asContextElement", "Lkotlinx/coroutines/ThreadContextElement;", "setSystemTenantHost", "TenancyHostState", "pdf"})
@SourceDebugExtension(value={"SMAP\nTenancyServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenancyServiceImpl.kt\norg/kuali/research/pdf/sys/tenancy/internal/service/TenancyServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1761#2,3:81\n*S KotlinDebug\n*F\n+ 1 TenancyServiceImpl.kt\norg/kuali/research/pdf/sys/tenancy/internal/service/TenancyServiceImpl\n*L\n19#1:81,3\n*E\n"})
public class TenancyServiceImpl
implements MutableTenancyService {
    @NotNull
    private final String kualiSpEnvironmentSystem;
    @NotNull
    private final String kualiPlatformEnvironmentSystem;
    @NotNull
    private final String kualiSpAppName;

    public TenancyServiceImpl(@Value(value="${kuali.sp.environment.system}") @NotNull String kualiSpEnvironmentSystem, @Value(value="${kuali.platform.environment.system}") @NotNull String kualiPlatformEnvironmentSystem, @Value(value="${kuali.sp.app.name}") @NotNull String kualiSpAppName) {
        Intrinsics.checkNotNullParameter((Object)kualiSpEnvironmentSystem, (String)"kualiSpEnvironmentSystem");
        Intrinsics.checkNotNullParameter((Object)kualiPlatformEnvironmentSystem, (String)"kualiPlatformEnvironmentSystem");
        Intrinsics.checkNotNullParameter((Object)kualiSpAppName, (String)"kualiSpAppName");
        this.kualiSpEnvironmentSystem = kualiSpEnvironmentSystem;
        this.kualiPlatformEnvironmentSystem = kualiPlatformEnvironmentSystem;
        this.kualiSpAppName = kualiSpAppName;
    }

    @Override
    public boolean isValidTenantHost(@NotNull String host) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Iterable $this$any$iv = TenancyService.Companion.getDOMAIN_TO_SYSTEM().keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)host, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean isSet() {
        return TenancyHostState.INSTANCE.getHosts().get() != null;
    }

    @Override
    public void setTenantHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (!this.isValidTenantHost(host)) {
            throw new IllegalArgumentException("Invalid tenant host: " + host);
        }
        TenancyHostState.INSTANCE.getHosts().set(host);
    }

    @Override
    public void removeTenantHost() {
        TenancyHostState.INSTANCE.getHosts().remove();
    }

    @Override
    @NotNull
    public String getTenantSigil() {
        String string = (String)TenancyHostState.INSTANCE.getHosts().get();
        if (string == null) {
            throw new IllegalStateException("tenant host not set");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R doInInternal(@NotNull TenancyService.ExternalSystem tenantType, @NotNull Function0<? extends R> task) {
        Intrinsics.checkNotNullParameter((Object)((Object)tenantType), (String)"tenantType");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (this.isSet()) {
            String previousHost = this.getTenantSigil();
            try {
                this.setSystemTenantHost(tenantType);
                Object object = task.invoke();
                return (R)object;
            }
            finally {
                this.setTenantHost(previousHost);
            }
        }
        try {
            this.setSystemTenantHost(tenantType);
            Object object = task.invoke();
            return (R)object;
        }
        finally {
            this.removeTenantHost();
        }
    }

    @Override
    @NotNull
    public String kualiSpAppName() {
        return this.kualiSpAppName;
    }

    @Override
    @NotNull
    public ThreadContextElement<String> asContextElement(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.isValidTenantHost(host)) {
            return ThreadContextElementKt.asContextElement((ThreadLocal)TenancyHostState.INSTANCE.getHosts(), (Object)host);
        }
        throw new IllegalArgumentException("Invalid tenant host: " + host);
    }

    public void setSystemTenantHost(@NotNull TenancyService.ExternalSystem tenantType) {
        Intrinsics.checkNotNullParameter((Object)((Object)tenantType), (String)"tenantType");
        String host = switch (WhenMappings.$EnumSwitchMapping$0[tenantType.ordinal()]) {
            case 1 -> this.kualiSpEnvironmentSystem;
            case 2 -> this.kualiPlatformEnvironmentSystem;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (!StringsKt.isBlank((CharSequence)host)) {
            this.setTenantHost(host);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/kuali/research/pdf/sys/tenancy/internal/service/TenancyServiceImpl$TenancyHostState;", "", "<init>", "()V", "hosts", "Ljava/lang/InheritableThreadLocal;", "", "getHosts", "()Ljava/lang/InheritableThreadLocal;", "pdf"})
    public static final class TenancyHostState {
        @NotNull
        public static final TenancyHostState INSTANCE = new TenancyHostState();
        @NotNull
        private static final InheritableThreadLocal<String> hosts = new InheritableThreadLocal();

        private TenancyHostState() {
        }

        @NotNull
        public final InheritableThreadLocal<String> getHosts() {
            return hosts;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TenancyService.ExternalSystem.values().length];
            try {
                nArray[TenancyService.ExternalSystem.SP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TenancyService.ExternalSystem.PLATFORM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

