/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.form.xfa;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.xfa.XfaForm;
import com.itextpdf.kernel.pdf.PdfDocument;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.ActionService;
import org.kuali.research.pdf.form.xfa.XfaPutAction;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.extensions.ItextExtensionsKt;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.xml.internal.AdobeXmlService;
import org.kuali.research.pdf.xml.internal.XmlExtensionsKt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B/\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J(\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0012J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/kuali/research/pdf/form/xfa/XfaPutActionServiceImpl;", "Lorg/kuali/research/pdf/action/ActionService;", "Lorg/kuali/research/pdf/form/xfa/XfaPutAction;", "Lorg/apache/logging/log4j/kotlin/Logging;", "actionHelperService", "Lorg/kuali/research/pdf/action/ActionHelperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "actionLinkInitFinalizeService", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "adobeXmlService", "Lorg/kuali/research/pdf/xml/internal/AdobeXmlService;", "<init>", "(Lorg/kuali/research/pdf/action/ActionHelperService;Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;Lorg/kuali/research/pdf/xml/internal/AdobeXmlService;)V", "getActionHelperService", "()Lorg/kuali/research/pdf/action/ActionHelperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getActionLinkInitFinalizeService", "()Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "getAdobeXmlService", "()Lorg/kuali/research/pdf/xml/internal/AdobeXmlService;", "init", "action", "exec", "putFormData", "executingAction", "form", "Lcom/itextpdf/forms/PdfAcroForm;", "document", "Lcom/itextpdf/kernel/pdf/PdfDocument;", "inputStream", "Ljava/io/InputStream;", "finalize", "pdf"})
@SourceDebugExtension(value={"SMAP\nXfaPutActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XfaPutActionServiceImpl.kt\norg/kuali/research/pdf/form/xfa/XfaPutActionServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public class XfaPutActionServiceImpl
implements ActionService<XfaPutAction>,
Logging {
    @NotNull
    private final ActionHelperService actionHelperService;
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final ActionLinkInitFinalizeService actionLinkInitFinalizeService;
    @NotNull
    private final AdobeXmlService adobeXmlService;

    public XfaPutActionServiceImpl(@Autowired @NotNull ActionHelperService actionHelperService, @Autowired @NotNull LinkService linkService, @Autowired @NotNull ActionLinkInitFinalizeService actionLinkInitFinalizeService, @Autowired @NotNull AdobeXmlService adobeXmlService) {
        Intrinsics.checkNotNullParameter((Object)actionHelperService, (String)"actionHelperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)actionLinkInitFinalizeService, (String)"actionLinkInitFinalizeService");
        Intrinsics.checkNotNullParameter((Object)adobeXmlService, (String)"adobeXmlService");
        this.actionHelperService = actionHelperService;
        this.linkService = linkService;
        this.actionLinkInitFinalizeService = actionLinkInitFinalizeService;
        this.adobeXmlService = adobeXmlService;
    }

    @NotNull
    public ActionHelperService getActionHelperService() {
        return this.actionHelperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public ActionLinkInitFinalizeService getActionLinkInitFinalizeService() {
        return this.actionLinkInitFinalizeService;
    }

    @NotNull
    public AdobeXmlService getAdobeXmlService() {
        return this.adobeXmlService;
    }

    @NotNull
    public XfaPutAction init(@NotNull XfaPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (XfaPutAction)this.getActionHelperService().initOneToOne((Action)action, arg_0 -> XfaPutActionServiceImpl.init$lambda$0(this, arg_0));
    }

    @NotNull
    public XfaPutAction exec(@NotNull XfaPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (XfaPutAction)this.getActionHelperService().execOneToOne((Action)action, (arg_0, arg_1) -> XfaPutActionServiceImpl.exec$lambda$0(action, this, arg_0, arg_1));
    }

    private XfaPutAction putFormData(XfaPutAction executingAction, PdfAcroForm form, PdfDocument document, InputStream inputStream) {
        XfaPutAction xfaPutAction;
        try {
            XfaForm xfaForm = form.getXfaForm();
            AdobeXmlService adobeXmlService = this.getAdobeXmlService();
            XfaForm xfaForm2 = form.getXfaForm();
            Intrinsics.checkNotNullExpressionValue((Object)xfaForm2, (String)"getXfaForm(...)");
            Node node = ItextExtensionsKt.getDataDescription((XfaForm)xfaForm2);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"newInstance(...)");
            xfaForm.fillXfaForm(adobeXmlService.populateFromDataDescription(node, CollectionsKt.listOf((Object)XmlExtensionsKt.parseWithNamespace((DocumentBuilderFactory)documentBuilderFactory, (InputStream)inputStream).getDocumentElement())));
            form.getXfaForm().write(document);
            xfaPutAction = executingAction;
        }
        catch (Exception e) {
            xfaPutAction = XfaPutAction.copy$default((XfaPutAction)executingAction, null, null, null, null, null, null, null, null, (List)CollectionsKt.plus((Collection)executingAction.getMessages(), (Object)Message.Companion.error$default((Message.Companion)Message.Companion, (String)("Inbound xml could not be parsed. " + e.getMessage()), (String)"xfadata.not.valid", null, (int)4, null)), (int)255, null);
        }
        return xfaPutAction;
    }

    @NotNull
    public XfaPutAction finalize(@NotNull XfaPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (XfaPutAction)this.getActionHelperService().finalizeOneToOne((Action)action, arg_0 -> XfaPutActionServiceImpl.finalize$lambda$0(this, arg_0));
    }

    private static final XfaPutAction init$lambda$0(XfaPutActionServiceImpl this$0, XfaPutAction executingAction) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link xfaDataSource = executingAction.getXfaDataSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)executingAction.getXfaDataSource(), (Action)executingAction) : executingAction.getXfaDataSource();
        return XfaPutAction.copy$default((XfaPutAction)executingAction, null, null, (Link)xfaDataSource, null, null, null, null, null, null, (int)507, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final XfaPutAction exec$lambda$0(XfaPutAction $action, XfaPutActionServiceImpl this$0, XfaPutAction executingAction, PdfDocument document) {
        Link link;
        block15: {
            block16: {
                block19: {
                    XfaPutAction xfaPutAction;
                    Link input;
                    Object it;
                    Object object;
                    PdfAcroForm form;
                    block18: {
                        block17: {
                            block14: {
                                Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
                                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                                form = PdfAcroForm.getAcroForm((PdfDocument)document, (boolean)false);
                                if (form != null) break block14;
                                link = XfaPutAction.copy$default((XfaPutAction)executingAction, null, null, null, null, null, null, null, null, (List)CollectionsKt.plus((Collection)executingAction.getMessages(), (Object)Message.Companion.error$default((Message.Companion)Message.Companion, (String)"The source pdf does not have an acroform.", (String)"source.acroform.not.found", null, (int)4, null)), (int)255, null);
                                break block15;
                            }
                            if (!form.hasXfaForm()) break block16;
                            object = $action.getXfaDataSource();
                            if (object == null) break block17;
                            it = object;
                            boolean bl = false;
                            InputStream inputStream = this$0.getLinkService().input(it);
                            object = inputStream;
                            if (inputStream != null) break block18;
                        }
                        String string = $action.getXfaData();
                        if (string != null) {
                            String it2 = string;
                            boolean bl = false;
                            byte[] byArray = it2.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                            object = new ByteArrayInputStream(byArray);
                        } else {
                            object = null;
                        }
                    }
                    if ((link = (input = object)) == null) break block19;
                    Closeable closeable = (Closeable)link;
                    Throwable throwable = null;
                    try {
                        it = (InputStream)closeable;
                        boolean bl = false;
                        XfaPutAction xfaPutAction2 = this$0.putFormData(executingAction, form, document, (InputStream)it);
                        xfaPutAction = xfaPutAction2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    link = xfaPutAction;
                    if (xfaPutAction != null) break block15;
                }
                link = XfaPutAction.copy$default((XfaPutAction)executingAction, null, null, null, null, null, null, null, null, (List)CollectionsKt.plus((Collection)executingAction.getMessages(), (Object)Message.Companion.error$default((Message.Companion)Message.Companion, (String)"Either xfaDataSource (a link) or xfaData (the xml as a string) are required to fill a form.", (String)"xfadata.not.found", null, (int)4, null)), (int)255, null);
                break block15;
            }
            link = XfaPutAction.copy$default((XfaPutAction)executingAction, null, null, null, null, null, null, null, null, (List)CollectionsKt.plus((Collection)executingAction.getMessages(), (Object)Message.Companion.error$default((Message.Companion)Message.Companion, (String)"The source pdf does not have an xfaform.", (String)"source.xfaform.not.found", null, (int)4, null)), (int)255, null);
        }
        return link;
    }

    private static final XfaPutAction finalize$lambda$0(XfaPutActionServiceImpl this$0, XfaPutAction executingAction) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link xfaDataSource = executingAction.getXfaDataSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)executingAction.getXfaDataSource(), (Action)executingAction) : executingAction.getXfaDataSource();
        return XfaPutAction.copy$default((XfaPutAction)executingAction, null, null, (Link)xfaDataSource, null, null, null, null, null, null, (int)507, null);
    }
}

