/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.health;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.health.HealthConstants;
import org.kuali.research.pdf.sys.service.StandardExternalServiceClient;
import org.kuali.research.pdf.sys.tenancy.TenancyService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/kuali/research/pdf/sys/health/AbstractExternalServiceHealthCheck;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "Lorg/springframework/beans/factory/InitializingBean;", "standardExternalServiceClient", "Lorg/kuali/research/pdf/sys/service/StandardExternalServiceClient;", "tenancyService", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService;", "<init>", "(Lorg/kuali/research/pdf/sys/service/StandardExternalServiceClient;Lorg/kuali/research/pdf/sys/tenancy/TenancyService;)V", "systemTenantType", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService$ExternalSystem;", "getSystemTenantType", "()Lorg/kuali/research/pdf/sys/tenancy/TenancyService$ExternalSystem;", "unsupportedTenantTypes", "", "getUnsupportedTenantTypes", "()Ljava/util/Set;", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "doConnectionChecking", "afterPropertiesSet", "pdf"})
public abstract class AbstractExternalServiceHealthCheck
extends AbstractHealthIndicator
implements InitializingBean {
    @NotNull
    private final StandardExternalServiceClient standardExternalServiceClient;
    @NotNull
    private final TenancyService tenancyService;
    @NotNull
    private final Set<TenancyService.ExternalSystem> unsupportedTenantTypes;

    public AbstractExternalServiceHealthCheck(@NotNull StandardExternalServiceClient standardExternalServiceClient, @NotNull TenancyService tenancyService) {
        Intrinsics.checkNotNullParameter((Object)standardExternalServiceClient, (String)"standardExternalServiceClient");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        this.standardExternalServiceClient = standardExternalServiceClient;
        this.tenancyService = tenancyService;
        this.unsupportedTenantTypes = SetsKt.emptySet();
    }

    @NotNull
    public abstract TenancyService.ExternalSystem getSystemTenantType();

    @NotNull
    public Set<TenancyService.ExternalSystem> getUnsupportedTenantTypes() {
        return this.unsupportedTenantTypes;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        try {
            if (this.tenancyService.isSet()) {
                if (this.getUnsupportedTenantTypes().contains(this.tenancyService.getExternalSystemType())) {
                    builder.status(HealthConstants.INSTANCE.getNOT_APPLICABLE());
                } else {
                    this.doConnectionChecking(builder);
                }
            } else {
                this.tenancyService.doInInternal(this.getSystemTenantType(), () -> AbstractExternalServiceHealthCheck.doHealthCheck$lambda$0(this, builder));
            }
        }
        catch (Exception e) {
            builder.withException((Throwable)e);
            builder.status(HealthConstants.INSTANCE.getDOWN_NON_FATAL());
        }
    }

    public final void doConnectionChecking(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Health.Builder builder2 = this.standardExternalServiceClient.isConnectedThrowing() ? builder.status(Status.UP) : builder.status(HealthConstants.INSTANCE.getDOWN_NON_FATAL());
    }

    public void afterPropertiesSet() {
        if (this.getUnsupportedTenantTypes().contains(this.getSystemTenantType())) {
            throw new IllegalStateException(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " is not supported in " + this.getSystemTenantType());
        }
    }

    private static final Unit doHealthCheck$lambda$0(AbstractExternalServiceHealthCheck this$0, Health.Builder $builder) {
        this$0.doConnectionChecking($builder);
        return Unit.INSTANCE;
    }
}

