/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.util.jaxb;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Date;

/**
 * An XML Adapter that relies on the DateTimeService to marshal and unmarshal datetime values in String form.
 * Converts Strings to java.util.Date instances and vice versa.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class StringToDateTimeAdapter extends XmlAdapter<String,Date> {

    /**
     * @see javax.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
     */
    @Override
    public Date unmarshal(String v) throws Exception {
        return (v != null) ? CoreApiServiceLocator.getDateTimeService().convertToDateTime(StringUtils.trim(v)) : null;
    }

    /**
     * @see javax.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
     */
    @Override
    public String marshal(Date v) throws Exception {
        return (v != null) ? CoreApiServiceLocator.getDateTimeService().toDateTimeString(v) : null;
    }

}
