/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.util.jaxb;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.apache.commons.lang.StringUtils;

/**
 * An XML adapter that simply performs a null-safe trim on the value to be marshalled or unmarshalled.
 * 
 * <p>Only use this adapter when it is necessary for the remaining whitespace-related characters to
 * remain as-is.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class StringTrimmingAdapter extends XmlAdapter<String,String> {

    /**
     * @see javax.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
     */
    @Override
    public String unmarshal(String v) throws Exception {
        return StringUtils.trim(v);
    }

    /**
     * @see javax.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
     */
    @Override
    public String marshal(String v) throws Exception {
        return StringUtils.trim(v);
    }

}
