/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.jaxb;

import java.io.Serializable;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.rice.core.util.jaxb.NameAndNamespacePair;
import org.kuali.rice.core.util.jaxb.NameAndNamespacePairValidatingAdapter;
import org.kuali.rice.core.util.jaxb.StringTrimmingAdapter;
import org.kuali.rice.kim.api.jaxb.NameAndNamespacePairToKimTypeIdAdapter;
import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.kim.impl.jaxb.RoleMembersXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RolePermissionsXmlDTO;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RoleType", propOrder={"roleNameAndNamespace", "kimTypeId", "roleDescription", "active", "roleMembers", "rolePermissions"})
public class RoleXmlDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private String roleId;
    @XmlElement(name="roleName")
    @XmlJavaTypeAdapter(value=NameAndNamespacePairValidatingAdapter.class)
    private NameAndNamespacePair roleNameAndNamespace;
    @XmlElement(name="kimTypeName")
    @XmlJavaTypeAdapter(value=NameAndNamespacePairToKimTypeIdAdapter.class)
    private String kimTypeId;
    @XmlElement(name="description")
    @XmlJavaTypeAdapter(value=StringTrimmingAdapter.class)
    private String roleDescription;
    @XmlElement(name="active")
    private Boolean active;
    @XmlElement(name="roleMembers")
    private RoleMembersXmlDTO.WithinRole roleMembers;
    @XmlElement(name="rolePermissions")
    private RolePermissionsXmlDTO.WithinRole rolePermissions;
    @XmlTransient
    private boolean alreadyPersisted = false;
    @XmlTransient
    private Set<String> existingRoleMemberIds;

    public RoleXmlDTO() {
        this.active = Boolean.TRUE;
    }

    public RoleXmlDTO(RoleContract role, RoleMembersXmlDTO.WithinRole roleMembers, RolePermissionsXmlDTO.WithinRole rolePermissions) {
        if (role == null) {
            throw new IllegalArgumentException("role cannot be null");
        }
        this.roleNameAndNamespace = new NameAndNamespacePair(role.getNamespaceCode(), role.getName());
        this.kimTypeId = role.getKimTypeId();
        this.roleDescription = role.getDescription();
        this.active = role.isActive();
        this.roleMembers = roleMembers;
        this.rolePermissions = rolePermissions;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public NameAndNamespacePair getRoleNameAndNamespace() {
        return this.roleNameAndNamespace;
    }

    public void setRoleNameAndNamespace(NameAndNamespacePair roleNameAndNamespace) {
        this.roleNameAndNamespace = roleNameAndNamespace;
    }

    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public void setKimTypeId(String kimTypeId) {
        this.kimTypeId = kimTypeId;
    }

    public String getRoleDescription() {
        return this.roleDescription;
    }

    public void setRoleDescription(String roleDescription) {
        this.roleDescription = roleDescription;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public RoleMembersXmlDTO.WithinRole getRoleMembers() {
        return this.roleMembers;
    }

    public void setRoleMembers(RoleMembersXmlDTO.WithinRole roleMembers) {
        this.roleMembers = roleMembers;
    }

    public RolePermissionsXmlDTO.WithinRole getRolePermissions() {
        return this.rolePermissions;
    }

    public void setRolePermissions(RolePermissionsXmlDTO.WithinRole rolePermissions) {
        this.rolePermissions = rolePermissions;
    }

    public boolean isAlreadyPersisted() {
        return this.alreadyPersisted;
    }

    public void setAlreadyPersisted(boolean alreadyPersisted) {
        this.alreadyPersisted = alreadyPersisted;
    }

    public Set<String> getExistingRoleMemberIds() {
        return this.existingRoleMemberIds;
    }

    public void setExistingRoleMemberIds(Set<String> existingRoleMemberIds) {
        this.existingRoleMemberIds = existingRoleMemberIds;
    }

    public String getRoleName() {
        return this.roleNameAndNamespace != null ? this.roleNameAndNamespace.getName() : null;
    }

    public String getNamespaceCode() {
        return this.roleNameAndNamespace != null ? this.roleNameAndNamespace.getNamespaceCode() : null;
    }
}

