/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.generators.mo;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.writer.SingleStreamCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.CoreConstants;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.devtools.generators.mo.Util;

public class ImmutableJaxbGenerator {
    public static void main(String[] args) throws Exception {
        if (args.length > 2 || args.length < 1) {
            System.err.println("There should be two arguments defined as follows:\n     1. Fully qualified class name of a 'contract' interface\n     2. [Optional] Fully qualified class name of the class to generate.  If not specified, will use the name of the contract interface class and remove \"Contract\" from the end of it.\n");
            System.exit(1);
        }
        String contractInterfaceName = args[0];
        String className = null;
        if (args.length == 2) {
            className = args[1];
        } else {
            if (!contractInterfaceName.endsWith("Contract")) {
                throw new IllegalArgumentException("If not explicitly specifying target classname, then contract class name must end with 'Contract'");
            }
            className = contractInterfaceName.substring(0, contractInterfaceName.lastIndexOf("Contract"));
        }
        Generator generator = new Generator(contractInterfaceName, className);
        generator.generate();
    }

    private static class FieldModel {
        private final String fieldName;
        private final Class<?> fieldType;

        private FieldModel(String fieldName, Class<?> fieldType) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }
    }

    public static class Generator {
        private final String contractInterfaceName;
        private final String className;
        private final JCodeModel codeModel;

        public Generator(String contractInterfaceName, String className) {
            this.contractInterfaceName = contractInterfaceName;
            this.className = className;
            this.codeModel = new JCodeModel();
        }

        public void generate() throws Exception {
            byte[] javaCode = this.generateJava();
            System.out.println(new String(javaCode));
        }

        private byte[] generateJava() throws Exception {
            JDefinedClass classModel = this.codeModel._class(9, this.className, ClassType.CLASS);
            Class<?> contractInterface = Class.forName(this.contractInterfaceName);
            classModel._implements(contractInterface);
            classModel._extends(AbstractDataTransferObject.class);
            List<FieldModel> fields = this.determineFields(contractInterface);
            this.renderConstantsClass(classModel);
            this.renderElementsClass(classModel, fields);
            this.renderClassLevelAnnotations(classModel, fields);
            this.renderFields(classModel, fields);
            this.renderFutureElementsField(classModel);
            this.renderPrivateJaxbConstructor(classModel, fields);
            this.renderBuilderConstructor(classModel, fields);
            this.renderGetters(classModel, fields);
            this.renderBuilderClass(classModel, fields, contractInterface);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.codeModel.build((CodeWriter)new SingleStreamCodeWriter((OutputStream)outputStream));
            return outputStream.toByteArray();
        }

        private List<FieldModel> determineFields(Class<?> contractInterface) throws Exception {
            Method[] methods;
            ArrayList<FieldModel> fieldModels = new ArrayList<FieldModel>();
            for (Method method : methods = contractInterface.getMethods()) {
                String methodName = method.getName();
                String fieldName = null;
                if (method.getReturnType() == Void.class || method.getParameterTypes().length != 0) continue;
                if (methodName.startsWith("get")) {
                    fieldName = Util.toLowerCaseFirstLetter(methodName.substring(3));
                } else {
                    if (!methodName.startsWith("is")) continue;
                    fieldName = Util.toLowerCaseFirstLetter(methodName.substring(2));
                }
                fieldModels.add(new FieldModel(fieldName, method.getReturnType()));
            }
            return fieldModels;
        }

        private void renderConstantsClass(JDefinedClass classModel) throws Exception {
            JDefinedClass constantsClass = classModel._class(16, "Constants");
            JDocComment javadoc = constantsClass.javadoc();
            javadoc.append((Object)"Defines some internal constants used on this class.");
            JFieldVar rootElementField = constantsClass.field(24, String.class, "ROOT_ELEMENT_NAME");
            rootElementField.init(JExpr.lit((String)Util.toLowerCaseFirstLetter(classModel.name())));
            JFieldVar typeNameField = constantsClass.field(24, String.class, "TYPE_NAME");
            typeNameField.init(JExpr.lit((String)(classModel.name() + "Type")));
        }

        private void renderElementsClass(JDefinedClass classModel, List<FieldModel> fields) throws Exception {
            JDefinedClass elementsClass = classModel._class(16, "Elements");
            JDocComment javadoc = elementsClass.javadoc();
            javadoc.append((Object)"A private class which exposes constants which define the XML element names to use when this object is marshalled to XML.");
            for (FieldModel fieldModel : fields) {
                if (Util.isCommonElement(fieldModel.fieldName)) continue;
                JFieldVar elementFieldVar = elementsClass.field(24, String.class, Util.toConstantsVariable(fieldModel.fieldName));
                elementFieldVar.init(JExpr.lit((String)fieldModel.fieldName));
            }
        }

        private void renderClassLevelAnnotations(JDefinedClass classModel, List<FieldModel> fields) throws Exception {
            JFieldRef constantsClass = classModel.staticRef("Constants");
            JFieldRef elementsClass = classModel.staticRef("Elements");
            JClass coreConstants = this.codeModel.ref(CoreConstants.class);
            JFieldRef commonElementsRef = coreConstants.staticRef("CommonElements");
            JAnnotationUse rootElementAnnotation = classModel.annotate(XmlRootElement.class);
            rootElementAnnotation.param("name", (JExpression)constantsClass.ref("ROOT_ELEMENT_NAME"));
            JAnnotationUse xmlAccessorTypeAnnotation = classModel.annotate(XmlAccessorType.class);
            xmlAccessorTypeAnnotation.param("value", (Enum)XmlAccessType.NONE);
            JAnnotationUse xmlTypeAnnotation = classModel.annotate(XmlType.class);
            xmlTypeAnnotation.param("name", (JExpression)constantsClass.ref("TYPE_NAME"));
            JAnnotationArrayMember propOrderMember = xmlTypeAnnotation.paramArray("propOrder");
            for (FieldModel field : fields) {
                if (Util.isCommonElement(field.fieldName)) {
                    propOrderMember.param((JExpression)commonElementsRef.ref(Util.toConstantsVariable(field.fieldName)));
                    continue;
                }
                propOrderMember.param((JExpression)elementsClass.ref(Util.toConstantsVariable(field.fieldName)));
            }
            propOrderMember.param((JExpression)commonElementsRef.ref("FUTURE_ELEMENTS"));
        }

        private void renderFields(JDefinedClass classModel, List<FieldModel> fields) {
            for (FieldModel fieldModel : fields) {
                this.renderField(classModel, fieldModel);
            }
        }

        private void renderField(JDefinedClass classModel, FieldModel fieldModel) {
            JFieldVar field = classModel.field(12, fieldModel.fieldType, fieldModel.fieldName);
            JAnnotationUse annotation = field.annotate(XmlElement.class);
            if (Util.isCommonElement(fieldModel.fieldName)) {
                JClass coreConstants = this.codeModel.ref(CoreConstants.class);
                JFieldRef commonElementsRef = coreConstants.staticRef("CommonElements");
                annotation.param("name", (JExpression)commonElementsRef.ref(Util.toConstantsVariable(fieldModel.fieldName)));
            } else {
                JClass elementsClass = this.codeModel.ref("Elements");
                JFieldRef fieldXmlNameRef = elementsClass.staticRef(Util.toConstantsVariable(fieldModel.fieldName));
                annotation.param("name", (JExpression)fieldXmlNameRef);
            }
            annotation.param("required", false);
        }

        private void renderFutureElementsField(JDefinedClass classModel) throws Exception {
            JType collectionType = this.codeModel.parseType("java.util.Collection<org.w3c.dom.Element>");
            JFieldVar field = classModel.field(12, collectionType, "_futureElements");
            field.init(JExpr._null());
            JAnnotationUse annotation = field.annotate(SuppressWarnings.class);
            annotation.param("value", "unused");
            field.annotate(XmlAnyElement.class);
        }

        private void renderPrivateJaxbConstructor(JDefinedClass classModel, List<FieldModel> fields) {
            JMethod method = classModel.constructor(4);
            JBlock body = method.body();
            for (FieldModel fieldModel : fields) {
                body.directStatement("this." + fieldModel.fieldName + " = " + this.getInitString(fieldModel.fieldType) + ";");
            }
            method.javadoc().add((Object)"Private constructor used only by JAXB.");
        }

        private String getInitString(Class<?> clazz) {
            if (clazz == Boolean.TYPE) {
                return "false";
            }
            if (clazz == Character.TYPE) {
                return "'\\\\u0000'";
            }
            if (clazz == Long.TYPE) {
                return "0L";
            }
            if (clazz == Float.TYPE) {
                return "0.0F";
            }
            if (clazz == Double.TYPE) {
                return "0.0D";
            }
            if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) {
                return "0";
            }
            return "null";
        }

        private void renderBuilderConstructor(JDefinedClass classModel, List<FieldModel> fields) {
            JMethod method = classModel.constructor(4);
            method.param((JType)this.codeModel.ref("Builder"), "builder");
            JBlock body = method.body();
            for (FieldModel fieldModel : fields) {
                body.directStatement("this." + fieldModel.fieldName + " = builder." + Util.generateGetter(fieldModel.fieldName, this.isBoolean(fieldModel.fieldType)) + ";");
            }
        }

        private void renderGetters(JDefinedClass classModel, List<FieldModel> fields) {
            for (FieldModel fieldModel : fields) {
                JMethod getterMethod = classModel.method(1, fieldModel.fieldType, Util.generateGetterName(fieldModel.fieldName, this.isBoolean(fieldModel.fieldType)));
                JBlock methodBody = getterMethod.body();
                methodBody.directStatement("return this." + fieldModel.fieldName + ";");
                getterMethod.annotate(Override.class);
            }
        }

        private boolean isBoolean(Class<?> clazz) {
            return clazz == Boolean.TYPE || clazz == Boolean.class;
        }

        private void renderBuilderClass(JDefinedClass classModel, List<FieldModel> fields, Class<?> contractInterface) throws Exception {
            JDefinedClass builderClass = classModel._class(25, "Builder");
            JClass literalBuilderClass = this.codeModel.ref("Builder");
            JDocComment javadoc = builderClass.javadoc();
            javadoc.append((Object)Util.generateBuilderJavadoc(classModel.name(), contractInterface.getSimpleName()));
            builderClass._implements(contractInterface);
            builderClass._implements(ModelBuilder.class);
            builderClass._implements(Serializable.class);
            for (FieldModel fieldModel : fields) {
                builderClass.field(4, fieldModel.fieldType, fieldModel.fieldName);
            }
            JMethod constructor = builderClass.constructor(4);
            constructor.body().directStatement("// TODO modify this constructor as needed to pass any required values and invoke the appropriate 'setter' methods");
            this.renderBuilderDefaultCreate(builderClass, literalBuilderClass);
            this.renderBuilderCreateContract(builderClass, literalBuilderClass, fields, contractInterface);
            this.renderBuild(builderClass);
            this.renderGetters(builderClass, fields);
            this.renderSetters(builderClass, fields);
        }

        private void renderBuilderDefaultCreate(JDefinedClass builderClass, JClass literalBuilderClass) {
            JMethod createMethod = builderClass.method(17, (JType)literalBuilderClass, "create");
            JBlock createMethodBody = createMethod.body();
            createMethodBody.directStatement("// TODO modify as needed to pass any required values and add them to the signature of the 'create' method");
            createMethodBody.directStatement("return new Builder();");
        }

        private void renderBuilderCreateContract(JDefinedClass builderClass, JClass literalBuilderClass, List<FieldModel> fields, Class<?> contractInterface) {
            JMethod createContractMethod = builderClass.method(17, (JType)literalBuilderClass, "create");
            JVar contractParam = createContractMethod.param(contractInterface, "contract");
            JBlock body = createContractMethod.body();
            JConditional nullContractCheck = body._if(contractParam.eq(JExpr._null()));
            nullContractCheck._then().directStatement("throw new IllegalArgumentException(\"contract was null\");");
            body.directStatement("// TODO if create() is modified to accept required parameters, this will need to be modified");
            body.directStatement("Builder builder = create();");
            for (FieldModel fieldModel : fields) {
                String fieldName = fieldModel.fieldName;
                body.directStatement("builder." + Util.generateSetter(fieldName, "contract." + Util.generateGetter(fieldName, this.isBoolean(fieldModel.fieldType))) + ";");
            }
            body.directStatement("return builder;");
        }

        private void renderBuild(JDefinedClass builderClass) {
            JMethod buildMethod = builderClass.method(1, (JType)builderClass.outer(), "build");
            buildMethod.body().directStatement("return new " + builderClass.outer().name() + "(this);");
        }

        private void renderSetters(JDefinedClass builderClass, List<FieldModel> fields) {
            for (FieldModel fieldModel : fields) {
                String fieldName = fieldModel.fieldName;
                JMethod setterMethod = builderClass.method(1, (JType)this.codeModel.VOID, Util.generateSetterName(fieldName));
                setterMethod.param(fieldModel.fieldType, fieldName);
                setterMethod.body().directStatement("// TODO add validation of input value if required and throw IllegalArgumentException if needed");
                setterMethod.body().directStatement("this." + fieldName + " = " + fieldName + ";");
            }
        }
    }
}

