/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class TemporalResolver
extends AbstractMappedFieldResolver {
    private static final Log LOG = LogFactory.getLog(TemporalResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "Temporal";
    public static final String DATE = "DATE";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TIME = "TIME";

    public TemporalResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.Temporal";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        FieldDescriptor fd = OjbUtil.findFieldDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (fd != null) {
            Class<?> fc = ResolverUtil.getType(enclosingClass, fieldName);
            String columnType = fd.getColumnType();
            if (this.isJavaSqlDate(fc)) {
                LOG.warn((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " is a java.sql.Date. " + this.getWarnMessageFragment(columnType)));
            } else if (this.isJavaSqlTimestamp(fc)) {
                LOG.warn((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " is a java.sql.Timestamp. " + this.getWarnMessageFragment(columnType)));
            } else if (this.isJavaSqlTime(fc)) {
                LOG.warn((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " is a java.sql.Time. " + this.getWarnMessageFragment(columnType)));
            } else if (this.isJavaUtilDate(fc) || this.isJavaUtilCalendar(fc)) {
                if (DATE.equals(columnType)) {
                    return new NodeData((AnnotationExpr)new SingleMemberAnnotationExpr(new NameExpr(SIMPLE_NAME), (Expression)new NameExpr("TemporalType.DATE")), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), Collections.singletonList(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "TemporalType"), false, false)));
                }
                if (TIMESTAMP.equals(columnType)) {
                    return new NodeData((AnnotationExpr)new SingleMemberAnnotationExpr(new NameExpr(SIMPLE_NAME), (Expression)new NameExpr("TemporalType.TIMESTAMP")), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), Collections.singletonList(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "TemporalType"), false, false)));
                }
                if (TIME.equals(columnType)) {
                    return new NodeData((AnnotationExpr)new SingleMemberAnnotationExpr(new NameExpr(SIMPLE_NAME), (Expression)new NameExpr("TemporalType.TIME")), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), Collections.singletonList(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "TemporalType"), false, false)));
                }
                LOG.error((Object)(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " is a java.sql.Date or java.util.Calendar but the column type " + columnType + " is unknown.  Unable to add @Temporal annotation"));
            }
            return null;
        }
        return null;
    }

    private boolean isJavaUtilDate(Class<?> fc) {
        if (fc != null) {
            return !Date.class.isAssignableFrom(fc) && java.util.Date.class.isAssignableFrom(fc);
        }
        return false;
    }

    private boolean isJavaUtilCalendar(Class<?> fc) {
        if (fc != null) {
            return Calendar.class.isAssignableFrom(fc);
        }
        return false;
    }

    private boolean isJavaSqlDate(Class<?> fc) {
        if (fc != null) {
            return Date.class.isAssignableFrom(fc);
        }
        return false;
    }

    private boolean isJavaSqlTimestamp(Class<?> fc) {
        if (fc != null) {
            return Timestamp.class.isAssignableFrom(fc);
        }
        return false;
    }

    private boolean isJavaSqlTime(Class<?> fc) {
        if (fc != null) {
            return Time.class.isAssignableFrom(fc);
        }
        return false;
    }

    private String getWarnMessageFragment(String columnType) {
        if (DATE.equals(columnType)) {
            return "Consider converting to java.util.Calendar or java.util.Date with a @Temporal(TemporalType.DATE) annotation";
        }
        if (TIMESTAMP.equals(columnType)) {
            return "Consider converting to java.util.Calendar or java.util.Date with a @Temporal(TemporalType.TIMESTAMP) annotation";
        }
        if (TIME.equals(columnType)) {
            return "Consider converting to java.util.Calendar or java.util.Date with a @Temporal(TemporalType.TIME) annotation";
        }
        return "Consider converting to java.util.Calendar or java.util.Date with a @Temporal annotation";
    }
}

