/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.framework.workflow;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.edl.framework.extract.DumpDTO;
import org.kuali.rice.edl.framework.extract.ExtractService;
import org.kuali.rice.edl.framework.extract.FieldDTO;
import org.kuali.rice.edl.framework.services.EdlFrameworkServiceLocator;
import org.kuali.rice.edl.framework.workflow.EDocLitePostProcessor;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DeleteEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.w3c.dom.Node;

public class EDocLiteDatabasePostProcessor
extends EDocLitePostProcessor {
    private static final Logger LOG = Logger.getLogger(EDocLiteDatabasePostProcessor.class);

    @Override
    public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange event) throws RemoteException {
        LOG.debug((Object)("doRouteStatusChange: " + event));
        String documentId = event.getDocumentId();
        EDocLitePostProcessor.postEvent(documentId, event, "statusChange");
        org.w3c.dom.Document doc = EDocLiteDatabasePostProcessor.getEDLContent(documentId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Submitting doc: " + XmlJotter.jotNode((Node)doc)));
        }
        this.extractEDLData(documentId, this.getNodeNames(event.getDocumentId()), doc);
        return super.doRouteStatusChange(event);
    }

    @Override
    public ProcessDocReport doActionTaken(ActionTakenEvent event) throws RemoteException {
        LOG.debug((Object)("doActionTaken: " + event));
        String documentId = event.getDocumentId();
        EDocLitePostProcessor.postEvent(documentId, event, "actionTaken");
        if ("S".equals(event.getActionTaken().getActionTaken())) {
            org.w3c.dom.Document doc = EDocLiteDatabasePostProcessor.getEDLContent(documentId);
            this.extractEDLData(documentId, this.getNodeNames(event.getDocumentId()), doc);
        }
        return super.doActionTaken(event);
    }

    @Override
    public ProcessDocReport doDeleteRouteHeader(DeleteEvent event) throws RemoteException {
        LOG.debug((Object)("doDeleteRouteHeader: " + event));
        EDocLitePostProcessor.postEvent(event.getDocumentId(), event, "deleteRouteHeader");
        return super.doDeleteRouteHeader(event);
    }

    @Override
    public ProcessDocReport doRouteLevelChange(DocumentRouteLevelChange event) throws RemoteException {
        LOG.debug((Object)("doRouteLevelChange: " + event));
        String documentId = event.getDocumentId();
        EDocLitePostProcessor.postEvent(documentId, event, "routeLevelChange");
        org.w3c.dom.Document doc = EDocLiteDatabasePostProcessor.getEDLContent(documentId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Submitting doc: " + XmlJotter.jotNode((Node)doc)));
        }
        this.extractEDLData(documentId, new String[]{event.getNewNodeName()}, doc);
        return super.doRouteLevelChange(event);
    }

    private String[] getNodeNames(String documentId) {
        List activeNodeInstances = KewApiServiceLocator.getWorkflowDocumentService().getActiveRouteNodeNames(documentId);
        if (activeNodeInstances == null || activeNodeInstances.isEmpty()) {
            activeNodeInstances = KewApiServiceLocator.getWorkflowDocumentService().getTerminalRouteNodeNames(documentId);
        }
        return activeNodeInstances != null ? activeNodeInstances.toArray(new String[0]) : new String[]{};
    }

    private void extractEDLData(String documentId, String[] nodeNames, org.w3c.dom.Document documentContent) {
        try {
            Document document = KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId);
            DocumentType documentType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeById(document.getDocumentTypeId());
            DumpDTO dump = this.getExtractService().getDumpByDocumentId(documentId);
            if (dump == null) {
                dump = new DumpDTO();
            }
            dump.setDocId(documentId);
            dump.setDocCreationDate(new Timestamp(document.getDateCreated().getMillis()));
            dump.setDocCurrentNodeName(StringUtils.join((Object[])nodeNames, (String)","));
            dump.setDocDescription(documentType.getDescription());
            if (document.getDateLastModified() != null) {
                dump.setDocModificationDate(new Timestamp(document.getDateLastModified().getMillis()));
            }
            dump.setDocInitiatorId(document.getInitiatorPrincipalId());
            dump.setDocRouteStatusCode(document.getStatus().getCode());
            dump.setDocTypeName(documentType.getName());
            List<FieldDTO> fields = dump.getFields();
            fields.clear();
            List fieldElements = this.setExtractFields(documentContent);
            Iterator iter = fieldElements.iterator();
            while (iter.hasNext()) {
                FieldDTO field = new FieldDTO();
                field.setDocId(dump.getDocId());
                Element element = (Element)iter.next();
                Attribute attribute = element.getAttribute("name");
                field.setFieldName(attribute.getValue());
                field.setFieldValue(element.getChildText("value"));
                fields.add(field);
            }
            dump.setFields(fields);
            this.getExtractService().saveDump(dump);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private ExtractService getExtractService() {
        return EdlFrameworkServiceLocator.getExtractService();
    }

    private static Element getRootElement(org.w3c.dom.Document docContent) {
        return XmlHelper.buildJDocument((org.w3c.dom.Document)docContent).getRootElement();
    }

    private List setExtractFields(org.w3c.dom.Document documentContent) {
        Element rootElement = EDocLiteDatabasePostProcessor.getRootElement(documentContent);
        ArrayList<Element> fields = new ArrayList<Element>();
        Collection fieldElements = XmlHelper.findElements((Element)rootElement, (String)"field");
        for (Element field : fieldElements) {
            Element version = field.getParentElement();
            if (!version.getAttribute("current").getValue().equals("true") || field.getAttribute("name") == null) continue;
            fields.add(field);
        }
        return fields;
    }
}

