/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.impex.xml.XmlIngestionException;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.style.Style;
import org.kuali.rice.coreservice.api.style.StyleService;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.bo.EDocLiteDefinition;
import org.kuali.rice.edl.impl.service.EDocLiteService;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EDocLiteXmlParser {
    private static final Logger LOG = LogManager.getLogger(EDocLiteXmlParser.class);

    public static void loadXml(InputStream inputStream, String principalId) {
        NodeList edls;
        Document doc;
        DocumentBuilder db = EDLXmlUtils.getDocumentBuilder();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            doc = db.parse(inputStream);
        }
        catch (Exception e) {
            throw EDocLiteXmlParser.generateException("Error parsing EDocLite XML file", e);
        }
        try {
            edls = (NodeList)xpath.evaluate("//edoclite", doc.getFirstChild(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw EDocLiteXmlParser.generateException("Error evaluating XPath expression", e);
        }
        for (int i = 0; i < edls.getLength(); ++i) {
            Node edl = edls.item(i);
            NodeList children = edl.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                if ("style".equals(node.getNodeName())) {
                    LOG.debug("Digesting EDocLiteStyle: " + e.getAttribute("name"));
                    Style style = EDocLiteXmlParser.parseStyle(e);
                    EDocLiteXmlParser.getStyleService().saveStyle(style);
                    continue;
                }
                if ("edl".equals(node.getNodeName())) {
                    LOG.debug("Digesting EDocLiteDefinition: " + e.getAttribute("name"));
                    EDocLiteDefinition def = EDocLiteXmlParser.parseEDocLiteDefinition(e);
                    EDocLiteXmlParser.getEDLService().saveEDocLiteDefinition(def);
                    continue;
                }
                if (!"association".equals(node.getNodeName())) continue;
                LOG.debug("Digesting EDocLiteAssociation: " + e.getAttribute("name"));
                EDocLiteAssociation assoc = EDocLiteXmlParser.parseEDocLiteAssociation(e);
                EDocLiteXmlParser.getEDLService().saveEDocLiteAssociation(assoc);
            }
        }
    }

    private static XmlIngestionException generateException(String error, Throwable cause) {
        throw new XmlIngestionException(error, cause);
    }

    private static EDocLiteAssociation parseEDocLiteAssociation(Element e) {
        String docType = EDLXmlUtils.getChildElementTextValue(e, "docType");
        if (docType == null) {
            throw EDocLiteXmlParser.generateMissingChildException("association", "docType");
        }
        EDocLiteAssociation assoc = new EDocLiteAssociation();
        assoc.setEdlName(docType);
        assoc.setDefinition(EDLXmlUtils.getChildElementTextValue(e, "definition"));
        assoc.setStyle(EDLXmlUtils.getChildElementTextValue(e, "style"));
        assoc.setActiveInd(Boolean.valueOf(EDLXmlUtils.getChildElementTextValue(e, "active")));
        return assoc;
    }

    private static Style parseStyle(Element e) {
        String name = e.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw EDocLiteXmlParser.generateMissingAttribException("style", "name");
        }
        Style.Builder styleBuilder = Style.Builder.create((String)name);
        Element stylesheet = null;
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"xsl:stylesheet".equals(child.getNodeName())) continue;
            stylesheet = (Element)child;
            break;
        }
        if (stylesheet == null) {
            throw EDocLiteXmlParser.generateMissingChildException("style", "xsl:stylesheet");
        }
        try {
            styleBuilder.setXmlContent(XmlJotter.jotNode(stylesheet, (boolean)true));
        }
        catch (XmlException te) {
            throw EDocLiteXmlParser.generateSerializationException("style", te);
        }
        return styleBuilder.build();
    }

    private static EDocLiteDefinition parseEDocLiteDefinition(Element e) {
        NodeList fields;
        EDocLiteDefinition def = new EDocLiteDefinition();
        String name = e.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw EDocLiteXmlParser.generateMissingAttribException("edl", "name");
        }
        def.setName(name);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            fields = (NodeList)xpath.evaluate("fieldDef", e, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpee) {
            throw new XmlIngestionException("Invalid EDocLiteDefinition", (Throwable)xpee);
        }
        if (fields != null) {
            ArrayList<String> invalidAttributes = new ArrayList<String>(5);
            for (int i = 0; i < fields.getLength(); ++i) {
                RuleAttribute ruleAttrib;
                Node node = fields.item(i);
                if (!(node instanceof Element)) continue;
                Element field = (Element)node;
                String fieldName = field.getAttribute("name");
                String attribute = field.getAttribute("attributeName");
                if (attribute == null || attribute.length() <= 0 || (ruleAttrib = KEWServiceLocator.getRuleAttributeService().findByName(attribute)) != null) continue;
                LOG.error("Invalid attribute referenced in EDocLite definition: " + attribute);
                invalidAttributes.add("Attribute '" + attribute + "' referenced in field '" + fieldName + "' not found");
            }
            if (invalidAttributes.size() > 0) {
                LOG.error("Invalid attributes referenced in EDocLite definition");
                StringBuffer message = new StringBuffer("EDocLite definition contains references to non-existent attributes;\n");
                Iterator it = invalidAttributes.iterator();
                while (it.hasNext()) {
                    message.append(it.next());
                    message.append("\n");
                }
                throw new XmlIngestionException(message.toString());
            }
        }
        try {
            def.setXmlContent(XmlJotter.jotNode((Node)e, (boolean)true));
        }
        catch (XmlException te) {
            throw EDocLiteXmlParser.generateSerializationException("edl", te);
        }
        return def;
    }

    private static XmlIngestionException generateMissingAttribException(String element, String attrib) {
        return EDocLiteXmlParser.generateException("EDocLite '" + element + "' element must contain a '" + attrib + "' attribute", null);
    }

    private static XmlIngestionException generateMissingChildException(String element, String child) {
        return EDocLiteXmlParser.generateException("EDocLite '" + element + "' element must contain a '" + child + "' child element", null);
    }

    private static XmlIngestionException generateSerializationException(String element, XmlException cause) {
        return EDocLiteXmlParser.generateException("Error serializing EDocLite '" + element + "' element", cause);
    }

    private static EDocLiteService getEDLService() {
        return EdlServiceLocator.getEDocLiteService();
    }

    private static StyleService getStyleService() {
        return CoreServiceApiServiceLocator.getStyleService();
    }
}

