/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.xml.export;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.style.Style;
import org.kuali.rice.coreservice.api.style.StyleService;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.bo.EDocLiteDefinition;
import org.kuali.rice.edl.impl.service.EDocLiteService;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.edl.impl.xml.export.EdlExportDataSet;

public class EDocLiteXmlExporter
implements XmlExporter {
    private static final Logger LOG = LogManager.getLogger(EDocLiteXmlExporter.class);
    private XmlRenderer renderer = new XmlRenderer(XmlConstants.EDL_NAMESPACE);

    public boolean supportPrettyPrint() {
        return false;
    }

    public Element export(ExportDataSet exportDataSet) {
        EdlExportDataSet dataSet = EdlExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getEdocLites().isEmpty()) {
            Element rootElement = this.renderer.renderElement(null, "edoclite");
            rootElement.setAttribute("schemaLocation", "ns:workflow/EDocLite resource:EDocLite", XmlConstants.SCHEMA_NAMESPACE);
            List<EDocLiteAssociation> assocList = dataSet.getEdocLites();
            for (EDocLiteAssociation e : assocList) {
                this.exportEdlDefinitions(rootElement, e);
            }
            for (EDocLiteAssociation e : assocList) {
                this.exportStyles(rootElement, e);
            }
            for (EDocLiteAssociation e : assocList) {
                this.exportAssociations(rootElement, e);
            }
            return rootElement;
        }
        return null;
    }

    private void exportEdlDefinitions(Element parentEl, EDocLiteAssociation edl) {
        try {
            EDocLiteService edlService = EdlServiceLocator.getEDocLiteService();
            if (edl.getDefinition() != null) {
                EDocLiteDefinition def = edlService.getEDocLiteDefinition(edl.getDefinition());
                if (def == null) {
                    LOG.error("Attempted to export definition " + edl.getDefinition() + " which was not found");
                    return;
                }
                Element defEl = XmlHelper.buildJDocument((Reader)new StringReader(def.getXmlContent())).getRootElement();
                this.setNamespace(defEl, XmlConstants.EDL_NAMESPACE);
                parentEl.addContent((Content)defEl.detach());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void exportStyles(Element parentEl, EDocLiteAssociation edl) {
        try {
            StyleService styleService = CoreServiceApiServiceLocator.getStyleService();
            if (edl.getStyle() != null) {
                Element styleWrapperEl = this.renderer.renderElement(parentEl, "style");
                this.renderer.renderAttribute(styleWrapperEl, "name", edl.getStyle());
                Style style = styleService.getStyle(edl.getStyle());
                if (style == null) {
                    LOG.error("Attempted to export style " + edl.getStyle() + " which was not found");
                    return;
                }
                Element styleEl = XmlHelper.buildJDocument((Reader)new StringReader(style.getXmlContent())).getRootElement();
                styleWrapperEl.addContent((Content)styleEl.detach());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void exportAssociations(Element parentEl, EDocLiteAssociation edl) {
        try {
            Element associationEl = this.renderer.renderElement(parentEl, "association");
            this.renderer.renderTextElement(associationEl, "docType", edl.getEdlName());
            if (edl.getDefinition() != null) {
                this.renderer.renderTextElement(associationEl, "definition", edl.getDefinition());
            }
            if (edl.getStyle() != null) {
                this.renderer.renderTextElement(associationEl, "style", edl.getStyle());
            }
            this.renderer.renderTextElement(associationEl, "active", edl.getActiveInd().toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setNamespace(Element element, Namespace namespace) {
        element.setNamespace(namespace);
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            this.setNamespace((Element)iter.next(), namespace);
        }
    }
}

