/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.io.IOException;
import java.io.InputStream;
import org.kuali.rice.ken.util.ClassLoaderResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClassLoaderEntityResolver
extends ClassLoaderResourceResolver
implements EntityResolver {
    public ClassLoaderEntityResolver() {
    }

    public ClassLoaderEntityResolver(String base, String prefix) {
        super(base, prefix);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.LOG.debug((Object)("Resolving '" + publicId + "' / '" + systemId + "'"));
        String path = this.resolveSystemId(systemId);
        if (path == null) {
            this.LOG.error((Object)("Unable to resolve system id '" + systemId + "' locally...delegating to default resolution strategy."));
            return null;
        }
        this.LOG.debug((Object)("Looking up resource '" + path + "' for entity '" + systemId + "'"));
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        if (is == null) {
            String message = "Unable to find schema (" + path + ") for: " + systemId;
            this.LOG.warn((Object)message);
            return null;
        }
        return new InputSource(is);
    }

    public String toString() {
        return "[ClassLoaderEntityResolver: base=" + this.base + ", prefix=" + this.prefix + "]";
    }
}

