/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.NotificationWorkflowDocumentService;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class NotificationController
extends MultiActionController {
    private static final Logger LOG = Logger.getLogger(NotificationController.class);
    protected NotificationService notificationService;
    protected NotificationWorkflowDocumentService notificationWorkflowDocService;
    protected NotificationMessageDeliveryService messageDeliveryService;

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setNotificationWorkflowDocumentService(NotificationWorkflowDocumentService s) {
        this.notificationWorkflowDocService = s;
    }

    public void setMessageDeliveryService(NotificationMessageDeliveryService messageDeliveryService) {
        this.messageDeliveryService = messageDeliveryService;
    }

    public ModelAndView displayHome(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "HomePage";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        HashMap model = new HashMap();
        return new ModelAndView(view, model);
    }

    public ModelAndView displayNotificationsSent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "NotificationsSent";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("userId", request.getRemoteUser());
        return new ModelAndView(view, model);
    }

    public ModelAndView displaySearch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "Search";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        HashMap model = new HashMap();
        return new ModelAndView(view, model);
    }

    public ModelAndView displayLookupUsers(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "LookupUsers";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        HashMap model = new HashMap();
        return new ModelAndView(view, model);
    }

    public ModelAndView displayLookupWorkgroups(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "LookupWorkgroups";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        HashMap model = new HashMap();
        return new ModelAndView(view, model);
    }

    protected NotificationMessageDelivery determineMessageFromRequest(HttpServletRequest request) {
        NotificationMessageDelivery messageDelivery;
        String messageDeliveryId = request.getParameter("messageDeliveryId");
        String delivererId = request.getParameter("delivererId");
        if (delivererId == null) {
            delivererId = request.getParameter("docId");
        }
        if (messageDeliveryId != null) {
            LOG.debug((Object)("Looking up notification with messageDeliveryId: " + messageDeliveryId));
            try {
                messageDelivery = this.messageDeliveryService.getNotificationMessageDelivery(new Long(messageDeliveryId));
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting message with id: " + messageDeliveryId, e);
            }
        } else if (delivererId != null) {
            LOG.debug((Object)("Looking up notification with workflowId: " + delivererId));
            try {
                messageDelivery = this.messageDeliveryService.getNotificationMessageDeliveryByDelivererId(delivererId);
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting message with from deliverer id: " + delivererId), (Throwable)e);
                throw new RuntimeException("Error getting message with deliverer id: " + delivererId, e);
            }
        } else {
            throw new RuntimeException("Neither message ('messageDeliveryId') nor deliverer id ('delivererId') were specified in the request");
        }
        return messageDelivery;
    }

    protected boolean requestIsFromKEW(HttpServletRequest req) {
        return req.getParameter("docId") != null;
    }

    public ModelAndView displayNotificationDetail(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "NotificationDetail";
        UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
        String principalId = "";
        if (userSession != null && StringUtils.isBlank((String)(principalId = userSession.getPrincipalId()))) {
            String principalName = request.getRemoteUser();
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName);
            if (principal != null) {
                principalId = principal.getPrincipalId();
            } else {
                throw new RuntimeException("There is no principal for principalName " + principalName);
            }
        }
        String command = request.getParameter("command");
        String standaloneWindow = request.getParameter("standaloneWindow");
        NotificationMessageDelivery messageDelivery = this.determineMessageFromRequest(request);
        NotificationBo notification = messageDelivery.getNotification();
        boolean actionable = false;
        if (this.requestIsFromKEW(request)) {
            if (command != null && (command.equals("displayActionListView") || command.equals("displayDocSearchView"))) {
                standaloneWindow = "true";
            }
            command = "displayActionListInlineView";
        }
        actionable = principalId.equals(messageDelivery.getUserRecipientId()) && "DELIVERED".equals(messageDelivery.getMessageDeliveryStatus());
        String documentId = request.getParameter("docId");
        if (StringUtils.isNotBlank((String)documentId)) {
            boolean authorized = KewApiServiceLocator.getWorkflowDocumentActionsService().isUserInRouteLog(documentId, principalId, false);
            LOG.debug((Object)("User in route log = " + authorized));
            if (!authorized) {
                HashMap<String, String> permissionDetails = new HashMap<String, String>();
                permissionDetails.put("Channel ID", notification.getChannel().getId().toString());
                HashMap qualification = new HashMap();
                authorized = KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(principalId, "KR-NTFCN", "View Notification", permissionDetails, qualification);
                LOG.debug((Object)("User has 'View Notification' permission = " + authorized));
                if (!authorized) {
                    return new ModelAndView("NotAuthorized");
                }
            }
        }
        List<NotificationSenderBo> senders = notification.getSenders();
        List<NotificationRecipientBo> recipients = notification.getRecipients();
        String contenthtml = Util.transformContent(notification);
        if (command != null && command.equals("displayActionListInlineView")) {
            view = "NotificationDetailInline";
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("notification", notification);
        model.put("senders", senders);
        model.put("recipients", recipients);
        model.put("contenthtml", contenthtml);
        model.put("messageDeliveryId", messageDelivery.getId());
        model.put("command", command);
        model.put("actionable", actionable);
        model.put("standaloneWindow", standaloneWindow);
        return new ModelAndView(view, model);
    }

    public ModelAndView dismissMessage(HttpServletRequest request, HttpServletResponse response) {
        String command = request.getParameter("action");
        if (command == null) {
            throw new RuntimeException("Dismissal command not specified");
        }
        if ("ack".equals(command)) {
            return this.dismissMessage(command, "Notificaton acknowledged.  Please refresh your action list.", request, response);
        }
        if ("fyi".equals(command)) {
            return this.dismissMessage(command, "Action Taken.  Please refresh your action list.", request, response);
        }
        throw new RuntimeException("Unknown dismissal command: " + command);
    }

    private ModelAndView dismissMessage(String action, String message, HttpServletRequest request, HttpServletResponse response) {
        String view = "NotificationDetail";
        String principalNm = request.getRemoteUser();
        String messageDeliveryId = request.getParameter("messageDeliveryId");
        String command = request.getParameter("command");
        String standaloneWindow = request.getParameter("standaloneWindow");
        if (messageDeliveryId == null) {
            throw new RuntimeException("A null messageDeliveryId was provided.");
        }
        LOG.debug((Object)("messageDeliveryId: " + messageDeliveryId));
        LOG.debug((Object)("command: " + command));
        NotificationMessageDelivery delivery = this.messageDeliveryService.getNotificationMessageDelivery(Long.decode(messageDeliveryId));
        if (delivery == null) {
            throw new RuntimeException("Could not find message delivery with id " + messageDeliveryId);
        }
        NotificationBo notification = delivery.getNotification();
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalNm);
        this.notificationService.dismissNotificationMessageDelivery(delivery.getId(), principal.getPrincipalId(), action);
        List<NotificationSenderBo> senders = notification.getSenders();
        List<NotificationRecipientBo> recipients = notification.getRecipients();
        String contenthtml = Util.transformContent(notification);
        if (standaloneWindow != null && standaloneWindow.equals("true")) {
            view = "NotificationActionTakenCloseWindow";
        } else if (command != null && command.equals("displayActionListInlineView")) {
            view = "NotificationDetailInline";
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("notification", notification);
        model.put("message", message);
        model.put("senders", senders);
        model.put("recipients", recipients);
        model.put("contenthtml", contenthtml);
        model.put("messageDeliveryId", messageDeliveryId);
        model.put("command", command);
        model.put("standaloneWindow", standaloneWindow);
        return new ModelAndView(view, model);
    }
}

