/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actiontaken.dao.impl;

import java.sql.Timestamp;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.actiontaken.dao.ActionTakenDao;
import org.kuali.rice.kew.api.action.ActionType;

public class ActionTakenDaoJpa
implements ActionTakenDao {
    private EntityManager entityManager;
    private static final Logger LOG = Logger.getLogger(ActionTakenDaoJpa.class);
    public static final String GET_LAST_ACTION_TAKEN_DATE_NAME = "ActionTakenValue.getLastActionTakenDate";
    public static final String GET_LAST_ACTION_TAKEN_DATE_QUERY = "SELECT max(a.actionDate) from ActionTakenValue a where a.documentId = :documentId and a.actionTaken=:actionTaken";

    @Override
    public Timestamp getLastActionTakenDate(String documentId, ActionType actionType) {
        if (StringUtils.isBlank((String)documentId) || actionType == null) {
            throw new IllegalArgumentException("Both documentId and actionType must be non-null");
        }
        TypedQuery query = this.entityManager.createNamedQuery(GET_LAST_ACTION_TAKEN_DATE_NAME, Timestamp.class);
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("actionTaken", (Object)actionType.getCode());
        try {
            return (Timestamp)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

