/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.AbstractRoleAttribute;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractIdRoleAttribute
extends AbstractRoleAttribute
implements GenericXMLRuleAttribute {
    private static final String XML_ELEMENT_LABEL = "xmlElementLabel";
    private static final String ROLE_NAME_LABEL = "roleNameLabel";
    private static final String GROUP_TOGETHER_LABEL = "groupTogether";
    private static final String STRING_ID_SEPERATOR = ",";
    private String idValue;
    private Map paramMap = new HashMap();
    private ExtensionDefinition extensionDefinition;

    protected abstract String getAttributeElementName();

    protected abstract Id resolveId(String var1);

    protected abstract String getIdName();

    @Override
    public List<String> getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        try {
            this.readConfiguration();
            String elementName = (String)this.getParamMap().get(XML_ELEMENT_LABEL);
            ArrayList<String> qualifiedRoleNames = new ArrayList<String>();
            XPath xPath = XPathHelper.newXPath();
            NodeList idNodes = (NodeList)xPath.evaluate("//" + this.getAttributeElementName() + "/" + elementName, documentContent.getDocument(), XPathConstants.NODESET);
            ArrayList<String> qualifiedRoleIds = new ArrayList<String>();
            for (int index = 0; index < idNodes.getLength(); ++index) {
                Element idElement = (Element)idNodes.item(index);
                String id = idElement.getTextContent();
                if (this.isGroupTogetherRole()) {
                    qualifiedRoleIds.add(id);
                    continue;
                }
                qualifiedRoleNames.add(id);
            }
            if (this.isGroupTogetherRole()) {
                qualifiedRoleNames.add(StringUtils.join(qualifiedRoleIds, (String)STRING_ID_SEPERATOR));
            }
            return qualifiedRoleNames;
        }
        catch (XPathExpressionException e) {
            throw new WorkflowRuntimeException("Failed to evaulate XPath expression to find ids.", (Throwable)e);
        }
    }

    private boolean isGroupTogetherRole() {
        String value = (String)this.getParamMap().get(GROUP_TOGETHER_LABEL);
        return StringUtils.isNotBlank((String)value) && value.equalsIgnoreCase("true");
    }

    @Override
    public ResolvedQualifiedRole resolveQualifiedRole(RouteContext routeContext, String roleName, String qualifiedRole) {
        String groupTogetherLabel;
        String roleNameLabel = (String)this.getParamMap().get(ROLE_NAME_LABEL);
        if (roleNameLabel == null) {
            this.readConfiguration();
            roleNameLabel = (String)this.getParamMap().get(ROLE_NAME_LABEL);
        }
        if ((groupTogetherLabel = (String)this.getParamMap().get(GROUP_TOGETHER_LABEL)) == null) {
            this.readConfiguration();
            groupTogetherLabel = (String)this.getParamMap().get(GROUP_TOGETHER_LABEL);
        }
        ResolvedQualifiedRole resolvedRole = new ResolvedQualifiedRole();
        resolvedRole.setQualifiedRoleLabel(roleNameLabel);
        if (this.isGroupTogetherRole()) {
            String[] qualifiedRoleIds;
            for (String qId : qualifiedRoleIds = StringUtils.split((String)qualifiedRole, (String)STRING_ID_SEPERATOR)) {
                resolvedRole.getRecipients().add(this.resolveId(qId));
            }
        } else {
            resolvedRole.getRecipients().add(this.resolveId(qualifiedRole));
        }
        return resolvedRole;
    }

    @Override
    public String getDocContent() {
        this.readConfiguration();
        if (!StringUtils.isBlank((String)this.getIdValue())) {
            String elementName = (String)this.getParamMap().get(XML_ELEMENT_LABEL);
            return "<" + this.getAttributeElementName() + "><" + elementName + ">" + this.getIdValue() + "</" + elementName + "></" + this.getAttributeElementName() + ">";
        }
        return "";
    }

    protected void readConfiguration() {
        String xmlConfigData;
        String idInMap = (String)this.getParamMap().get(this.getIdName());
        if (this.getIdValue() == null) {
            this.setIdValue(idInMap);
        }
        if (this.getIdValue() != null) {
            this.getParamMap().put(this.getIdName(), this.getIdValue());
        }
        if (this.extensionDefinition != null && !StringUtils.isBlank((String)(xmlConfigData = (String)this.extensionDefinition.getConfiguration().get("xmlConfigData")))) {
            XPath xPath = XPathHelper.newXPath();
            try {
                String xmlElementLabel = xPath.evaluate("/configuration/xmlElementLabel", new InputSource(new StringReader(xmlConfigData)));
                String roleNameLabel = xPath.evaluate("/configuration/roleNameLabel", new InputSource(new StringReader(xmlConfigData)));
                String groupTogetherLabel = xPath.evaluate("/configuration/groupTogether", new InputSource(new StringReader(xmlConfigData)));
                if (!StringUtils.isBlank((String)xmlElementLabel)) {
                    this.getParamMap().put(XML_ELEMENT_LABEL, xmlElementLabel);
                }
                if (!StringUtils.isBlank((String)roleNameLabel)) {
                    this.getParamMap().put(ROLE_NAME_LABEL, roleNameLabel);
                }
                if (!StringUtils.isBlank((String)groupTogetherLabel)) {
                    this.getParamMap().put(GROUP_TOGETHER_LABEL, groupTogetherLabel);
                }
            }
            catch (XPathExpressionException e) {
                throw new WorkflowRuntimeException("Failed to locate Rule Attribute configuration.");
            }
        }
        if (StringUtils.isBlank((String)((String)this.getParamMap().get(XML_ELEMENT_LABEL)))) {
            this.getParamMap().put(XML_ELEMENT_LABEL, this.getIdName());
        }
        if (this.getParamMap().get(ROLE_NAME_LABEL) == null) {
            this.getParamMap().put(ROLE_NAME_LABEL, "");
        }
        if (StringUtils.isBlank((String)((String)this.getParamMap().get(GROUP_TOGETHER_LABEL)))) {
            this.getParamMap().put(GROUP_TOGETHER_LABEL, "false");
        }
    }

    public String getIdValue() {
        return this.idValue;
    }

    public void setIdValue(String idValue) {
        this.idValue = idValue;
    }

    @Override
    public Map getParamMap() {
        return this.paramMap;
    }

    @Override
    public void setParamMap(Map paramMap) {
        this.paramMap = paramMap;
    }

    @Override
    public void setExtensionDefinition(ExtensionDefinition extensionDefinition) {
        this.extensionDefinition = extensionDefinition;
    }
}

