/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.web;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.engine.ActivationContext;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.AttributeDocumentContent;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routelog.web.RouteLogAction;
import org.kuali.rice.kew.routelog.web.RouteLogForm;
import org.kuali.rice.kew.rule.FlexRM;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.WorkflowRuleAttributeRows;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.rule.web.RoutingReportForm;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class RoutingReportAction
extends KewKualiAction {
    private static final Logger LOG = Logger.getLogger(RoutingReportAction.class);
    public static final String DOC_TYPE_REPORTING = "documentType";
    public static final String TEMPLATE_REPORTING = "template";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initiateForm(request, form);
        RoutingReportForm routingForm = (RoutingReportForm)form;
        if (StringUtils.isEmpty((String)routingForm.getDateRef())) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            routingForm.setEffectiveHour("5");
            routingForm.setEffectiveMinute("0");
            routingForm.setAmPm("1");
            routingForm.setDateRef(sdf.format(new Date()));
            routingForm.setReportType(TEMPLATE_REPORTING);
        }
        if (DOC_TYPE_REPORTING.equals(routingForm.getReportType())) {
            if (StringUtils.isEmpty((String)routingForm.getDocumentTypeParam())) {
                throw new RuntimeException("No document type was given");
            }
            if (StringUtils.isEmpty((String)routingForm.getInitiatorPrincipalId())) {
                throw new RuntimeException("No initiator principal id was given");
            }
            if (StringUtils.isEmpty((String)routingForm.getDocumentContent())) {
                throw new RuntimeException("No document content was given");
            }
        } else if (!TEMPLATE_REPORTING.equals(routingForm.getReportType())) {
            throw new RuntimeException("The Routing Report type is not set");
        }
        return super.execute(mapping, form, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward calculateRoute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoutingReportForm routingForm = (RoutingReportForm)form;
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (this.getDocumentTypeService().findByName(routingForm.getDocumentType()) == null) {
            GlobalVariables.getMessageMap().putError("Document type is required.", "doctype.documenttypeservice.doctypename.required", new String[0]);
        }
        Timestamp date = null;
        if (!StringUtils.isEmpty((String)routingForm.getDateRef())) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(sdf.parse(routingForm.getDateRef()));
                calendar.set(10, Integer.parseInt(routingForm.getEffectiveHour()));
                calendar.set(12, Integer.parseInt(routingForm.getEffectiveMinute()));
                calendar.set(9, Integer.parseInt(routingForm.getAmPm()));
                date = new Timestamp(calendar.getTimeInMillis());
            }
            catch (Exception e) {
                LOG.error((Object)"error parsing date", (Throwable)e);
                GlobalVariables.getMessageMap().putError("Invalid date.", "routereport.effectiveDate.invalid", new String[0]);
            }
        }
        if (!GlobalVariables.getMessageMap().hasNoErrors()) {
            throw new ValidationException("Errors populating rule attributes.");
        }
        DocumentTypeService documentTypeService = (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
        DocumentType docType = documentTypeService.findByName(routingForm.getDocumentType());
        DocumentRouteHeaderValue routeHeader = new DocumentRouteHeaderValue();
        routeHeader.setDocumentId("");
        routeHeader.setDocumentTypeId(docType.getDocumentTypeId());
        routeHeader.setDocRouteLevel(new Integer(0));
        routeHeader.setDocVersion(new Integer(1));
        ArrayList<RouteReportRuleTemplateContainer> ruleTemplateContainers = new ArrayList<RouteReportRuleTemplateContainer>();
        if (routingForm.getReportType().equals(DOC_TYPE_REPORTING)) {
            List<RouteNode> routeNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(docType, true);
            for (RouteNode routeNode : routeNodes) {
                RuleTemplateBo ruleTemplate;
                if (!routeNode.isFlexRM() || (ruleTemplate = this.getRuleTemplateService().findByRuleTemplateName(routeNode.getRouteMethodName())) == null) continue;
                ruleTemplateContainers.add(new RouteReportRuleTemplateContainer(ruleTemplate, routeNode));
                if (ruleTemplate.getDelegationTemplate() == null) continue;
                ruleTemplateContainers.add(new RouteReportRuleTemplateContainer(ruleTemplate.getDelegationTemplate(), routeNode));
            }
        } else {
            RuleTemplateBo ruleTemplate = this.getRuleTemplateService().findByRuleTemplateId(routingForm.getRuleTemplateId());
            RouteNode routeNode = new RouteNode();
            routeNode.setRouteNodeName(ruleTemplate.getName());
            ruleTemplateContainers.add(new RouteReportRuleTemplateContainer(ruleTemplate, routeNode));
            if (ruleTemplate.getDelegationTemplate() != null) {
                ruleTemplateContainers.add(new RouteReportRuleTemplateContainer(ruleTemplate.getDelegationTemplate(), routeNode));
            }
        }
        String xmlDocumentContent = routingForm.getDocumentContent();
        if (routingForm.getReportType().equals(TEMPLATE_REPORTING)) {
            ArrayList<Object> attributes = new ArrayList<Object>();
            for (RouteReportRuleTemplateContainer ruleTemplateContainer : ruleTemplateContainers) {
                RuleTemplateBo ruleTemplate = ruleTemplateContainer.ruleTemplate;
                for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
                    List<RemotableAttributeError> attValidationErrors;
                    if (!ruleTemplateAttribute.isWorkflowAttribute()) continue;
                    WorkflowRuleAttribute workflowAttribute = ruleTemplateAttribute.getWorkflowAttribute();
                    RuleAttribute ruleAttribute = ruleTemplateAttribute.getRuleAttribute();
                    if (ruleAttribute.getType().equals("RuleXmlAttribute")) {
                        ((GenericXMLRuleAttribute)workflowAttribute).setExtensionDefinition(RuleAttribute.to(ruleAttribute));
                    }
                    if ((attValidationErrors = workflowAttribute.validateRoutingData(routingForm.getFields())) != null && !attValidationErrors.isEmpty()) {
                        errors.addAll(attValidationErrors);
                    }
                    attributes.add(workflowAttribute);
                }
            }
            if (!GlobalVariables.getMessageMap().hasNoErrors()) {
                throw new ValidationException("errors in search criteria");
            }
            AttributeDocumentContent attributeDocumentContent = new AttributeDocumentContent(attributes);
            xmlDocumentContent = attributeDocumentContent.getDocContent();
        }
        routeHeader.setDocContent(xmlDocumentContent);
        routeHeader.setInitiatorWorkflowId(this.getUserSession(request).getPrincipalId());
        routeHeader.setDocRouteStatus("I");
        routeHeader.setDocTitle("Routing Report");
        routeHeader.setRoutingReport(true);
        long magicCounter = 0L;
        FlexRM flexRM = new FlexRM(date);
        int numberOfRules = 0;
        int numberOfActionRequests = 0;
        HashSet<String> alreadyProcessedRuleTemplateNames = new HashSet<String>();
        for (Object e : ruleTemplateContainers) {
            RouteContext context = RouteContext.createNewRouteContext();
            context.setActivationContext(new ActivationContext(true));
            try {
                RouteReportRuleTemplateContainer ruleTemplateContainer = (RouteReportRuleTemplateContainer)e;
                RuleTemplateBo ruleTemplate = ruleTemplateContainer.ruleTemplate;
                RouteNode routeLevel = ruleTemplateContainer.routeNode;
                if (alreadyProcessedRuleTemplateNames.contains(ruleTemplate.getName())) continue;
                alreadyProcessedRuleTemplateNames.add(ruleTemplate.getName());
                List<ActionRequestValue> actionRequests = flexRM.getActionRequests(routeHeader, routeLevel, null, ruleTemplate.getName());
                numberOfActionRequests += actionRequests.size();
                numberOfRules += flexRM.getNumberOfMatchingRules();
                magicCounter = this.populateActionRequestsWithRouteLevelInformationAndIterateMagicCounter(routeLevel, actionRequests, magicCounter);
                routeHeader.getSimulatedActionRequests().addAll(actionRequests);
            }
            finally {
                RouteContext.clearCurrentRouteContext();
            }
        }
        if (numberOfActionRequests == 0) {
            if (numberOfRules == 0) {
                GlobalVariables.getMessageMap().putError("*", "routereport.noRules", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError("*", "routereport.noMatchingRules", new String[0]);
            }
            if (GlobalVariables.getMessageMap().hasErrors()) {
                throw new ValidationException("errors in search criteria");
            }
        }
        RouteLogForm routeLogForm = new RouteLogForm();
        routeLogForm.setShowFuture(true);
        if (StringUtils.isNotBlank((String)routingForm.getBackUrl())) {
            routeLogForm.setReturnUrlLocation(routingForm.getBackUrl());
        }
        LOG.debug((Object)("Value of getDisplayCloseButton " + routingForm.getShowCloseButton()));
        LOG.debug((Object)("Value of isDisplayCloseButton " + routingForm.isDisplayCloseButton()));
        routeLogForm.setShowCloseButton(routingForm.isDisplayCloseButton());
        request.setAttribute("routeHeader", (Object)routeHeader);
        new RouteLogAction().populateRouteLogFormActionRequests(routeLogForm, routeHeader);
        request.setAttribute("KualiForm", (Object)routeLogForm);
        return mapping.findForward("routeLog");
    }

    public long populateActionRequestsWithRouteLevelInformationAndIterateMagicCounter(RouteNode routeLevel, List<ActionRequestValue> actionRequests, long magicCounter) {
        for (ActionRequestValue actionRequest : actionRequests) {
            this.populateActionRequestsWithRouteLevelInformationAndIterateMagicCounter(routeLevel, actionRequest.getChildrenRequests(), magicCounter);
            actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
            RouteNodeInstance routeNode = new RouteNodeInstance();
            routeNode.setRouteNode(routeLevel);
            actionRequest.setNodeInstance(routeNode);
            actionRequest.setRouteLevel(new Integer(0));
            actionRequest.setActionRequestId(String.valueOf(++magicCounter));
        }
        return magicCounter;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    private ActionMessages initiateForm(HttpServletRequest request, ActionForm form) throws Exception {
        RoutingReportForm routingReportForm = (RoutingReportForm)form;
        if (routingReportForm.getReportType() == null) {
            if (!(StringUtils.isEmpty((String)routingReportForm.getDocumentTypeParam()) && StringUtils.isEmpty((String)routingReportForm.getInitiatorPrincipalId()) && StringUtils.isEmpty((String)routingReportForm.getDocumentContent()))) {
                routingReportForm.setReportType(DOC_TYPE_REPORTING);
            } else {
                routingReportForm.setReportType(TEMPLATE_REPORTING);
            }
        }
        if (routingReportForm.getReportType().equals(DOC_TYPE_REPORTING)) {
            if (StringUtils.isEmpty((String)routingReportForm.getDocumentTypeParam())) {
                throw new RuntimeException("Document Type was not given");
            }
            DocumentType docType = this.getDocumentTypeService().findByName(routingReportForm.getDocumentTypeParam());
            if (docType == null) {
                throw new RuntimeException("Document Type is invalid");
            }
            if (StringUtils.isEmpty((String)routingReportForm.getInitiatorPrincipalId())) {
                throw new RuntimeException("Initiator Principal ID was not given");
            }
            KEWServiceLocator.getIdentityHelperService().getPrincipal(routingReportForm.getInitiatorPrincipalId());
            if (StringUtils.isEmpty((String)routingReportForm.getDocumentContent())) {
                throw new RuntimeException("Document Content was not given");
            }
            if (!StringUtils.isEmpty((String)routingReportForm.getDocumentType())) {
                docType = this.getDocumentTypeService().findByName(routingReportForm.getDocumentType());
                if (docType == null) {
                    throw new RuntimeException("Document Type is missing or invalid");
                }
                routingReportForm.getRuleTemplateAttributes().clear();
                List<RouteNode> routeNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(docType, true);
                for (RouteNode routeNode : routeNodes) {
                    RuleTemplateBo ruleTemplate;
                    if (!routeNode.isFlexRM() || (ruleTemplate = this.getRuleTemplateService().findByRuleTemplateName(routeNode.getRouteMethodName())) == null) continue;
                    this.loadRuleTemplateOnForm(ruleTemplate, routingReportForm, request, false);
                    if (ruleTemplate.getDelegationTemplate() == null) continue;
                    this.loadRuleTemplateOnForm(ruleTemplate.getDelegationTemplate(), routingReportForm, request, true);
                }
            }
        } else if (routingReportForm.getReportType().equals(TEMPLATE_REPORTING)) {
            routingReportForm.setRuleTemplates(this.getRuleTemplateService().findAll());
            if (routingReportForm.getRuleTemplateId() != null) {
                RuleTemplateBo ruleTemplate = this.getRuleTemplateService().findByRuleTemplateId(routingReportForm.getRuleTemplateId());
                routingReportForm.getRuleTemplateAttributes().clear();
                if (ruleTemplate != null) {
                    this.loadRuleTemplateOnForm(ruleTemplate, routingReportForm, request, false);
                    if (ruleTemplate.getDelegationTemplate() != null) {
                        this.loadRuleTemplateOnForm(ruleTemplate.getDelegationTemplate(), routingReportForm, request, true);
                    }
                }
            }
        }
        return null;
    }

    private void loadRuleTemplateOnForm(RuleTemplateBo ruleTemplate, RoutingReportForm routingReportForm, HttpServletRequest request, boolean isDelegate) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        List<RuleTemplateAttributeBo> ruleTemplateAttributes = ruleTemplate.getActiveRuleTemplateAttributes();
        Collections.sort(ruleTemplateAttributes);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplateAttributes) {
            ArrayList<Field> fields;
            if (!ruleTemplateAttribute.isWorkflowAttribute()) continue;
            WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getRoutingDataRows(fieldValues, ruleTemplateAttribute);
            for (Row row : workflowRuleAttributeRows.getRows()) {
                fields = new ArrayList<Field>();
                for (Object element2 : row.getFields()) {
                    Field field = (Field)element2;
                    if (request.getParameter(field.getPropertyName()) != null) {
                        field.setPropertyValue(request.getParameter(field.getPropertyName()));
                    } else if (routingReportForm.getFields() != null && !routingReportForm.getFields().isEmpty()) {
                        field.setPropertyValue((String)routingReportForm.getFields().get(field.getPropertyName()));
                    }
                    fields.add(field);
                    fieldValues.put(field.getPropertyName(), field.getPropertyValue());
                }
            }
            for (Row row : workflowRuleAttributeRows.getRows()) {
                fields = new ArrayList();
                List rowFields = row.getFields();
                for (Field field : rowFields) {
                    if (request.getParameter(field.getPropertyName()) != null) {
                        field.setPropertyValue(request.getParameter(field.getPropertyName()));
                    } else if (routingReportForm.getFields() != null && !routingReportForm.getFields().isEmpty()) {
                        field.setPropertyValue((String)routingReportForm.getFields().get(field.getPropertyName()));
                    }
                    fields.add(field);
                    fieldValues.put(field.getPropertyName(), field.getPropertyValue());
                }
                row.setFields(fields);
                rows.add(row);
            }
        }
        routingReportForm.getFields().putAll(fieldValues);
        routingReportForm.getRuleTemplateAttributes().addAll(rows);
        routingReportForm.setShowFields(true);
        routingReportForm.setShowViewResults(true);
    }

    public ActionForward loadTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoutingReportForm routingReportForm = (RoutingReportForm)form;
        if (StringUtils.isEmpty((String)routingReportForm.getDateRef())) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            routingReportForm.setEffectiveHour("5");
            routingReportForm.setEffectiveMinute("0");
            routingReportForm.setAmPm("1");
            routingReportForm.setDateRef(sdf.format(new Date()));
        }
        return mapping.findForward("basic");
    }

    private RuleTemplateService getRuleTemplateService() {
        return (RuleTemplateService)KEWServiceLocator.getService("enRuleTemplateService");
    }

    private DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
    }

    private UserSession getUserSession(HttpServletRequest request) {
        return GlobalVariables.getUserSession();
    }

    private class RouteReportRuleTemplateContainer {
        public RuleTemplateBo ruleTemplate = null;
        public RouteNode routeNode = null;

        public RouteReportRuleTemplateContainer(RuleTemplateBo template, RouteNode node) {
            this.ruleTemplate = template;
            this.routeNode = node;
        }
    }
}

