/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.data.DataIntegrityService;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class DataIntegrityAction
extends KualiAction {
    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        boolean authorized = false;
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        RoleService roleService = KimApiServiceLocator.getRoleService();
        String roleId = roleService.getRoleIdByNamespaceCodeAndName("KR-SYS", "Technical Administrator");
        if (roleId != null) {
            authorized = roleService.principalHasRole(principalId, Collections.singletonList(roleId), new HashMap(), true);
        }
        if (!authorized) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), methodToCall, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    public ActionForward check(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<String> messages = this.getDataIntegrityService().checkIntegrity();
        if (messages.isEmpty()) {
            messages = Collections.singletonList("No data integrity issues found.");
        }
        request.setAttribute("checkMessages", messages);
        return mapping.findForward("basic");
    }

    public ActionForward repair(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<String> messages = this.getDataIntegrityService().repair();
        if (messages.isEmpty()) {
            messages = Collections.singletonList("No data repair was necessary.");
        }
        request.setAttribute("repairMessages", messages);
        return mapping.findForward("basic");
    }

    public DataIntegrityService getDataIntegrityService() {
        return KimImplServiceLocator.getDataIntegrityService();
    }
}

