/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.web.struts.action.IdentityManagementBaseInquiryAction;
import org.kuali.rice.kim.web.struts.form.IdentityManagementDocumentFormBase;
import org.kuali.rice.kim.web.struts.form.IdentityManagementRoleDocumentForm;
import org.kuali.rice.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.rice.krad.util.GlobalVariables;

public class IdentityManagementRoleInquiry
extends IdentityManagementBaseInquiryAction {
    private static final Logger LOG = Logger.getLogger(IdentityManagementRoleInquiry.class);

    @Override
    protected void loadKimObject(HttpServletRequest request, IdentityManagementDocumentFormBase form) {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        String id = request.getParameter("id");
        String altId = request.getParameter("roleId");
        String roleId = StringUtils.isNotEmpty((String)id) ? id : altId;
        Role role = KimApiServiceLocator.getRoleService().getRole(roleId);
        if (role != null) {
            this.getUiDocumentService().loadRoleDoc(roleDocumentForm.getRoleDocument(), role);
        } else {
            LOG.error((Object)("No records found for Role Inquiry: " + request.getParameterMap()));
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.inquiry", new String[0]);
        }
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        ActionForward forward = super.execute(mapping, form, request, response);
        String previouslySortedColumnName = (String)GlobalVariables.getUserSession().retrieveObject("KIM_ROLE_INQUIRY_SORT_PREV_COL_NM");
        Boolean sortDescending = (Boolean)GlobalVariables.getUserSession().retrieveObject("KIM_ROLE_INQUIRY_SORT_DESC_VALUE");
        KualiTableRenderFormMetadata memberTableMetadata = roleDocumentForm.getMemberTableMetadata();
        memberTableMetadata.setPreviouslySortedColumnName(previouslySortedColumnName);
        String columnToSort = memberTableMetadata.getColumnToSortName();
        if (previouslySortedColumnName != null && StringUtils.isEmpty((String)columnToSort)) {
            memberTableMetadata.setColumnToSortName(previouslySortedColumnName);
        }
        if (sortDescending != null && !StringUtils.isEmpty((String)columnToSort)) {
            memberTableMetadata.setSortDescending(sortDescending.booleanValue());
        }
        if (roleDocumentForm.getMemberRows() != null) {
            memberTableMetadata.sort(roleDocumentForm.getMemberRows(), roleDocumentForm.getRecordsPerPage());
            memberTableMetadata.jumpToPage(memberTableMetadata.getSwitchToPageNumber(), roleDocumentForm.getMemberRows().size(), roleDocumentForm.getRecordsPerPage());
        }
        GlobalVariables.getUserSession().addObject("KIM_ROLE_INQUIRY_SORT_PREV_COL_NM", (Object)memberTableMetadata.getPreviouslySortedColumnName());
        GlobalVariables.getUserSession().addObject("KIM_ROLE_INQUIRY_SORT_DESC_VALUE", (Object)memberTableMetadata.isSortDescending());
        return forward;
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        String memberSearchValue = roleDocumentForm.getMemberSearchValue();
        if (memberSearchValue != null && !memberSearchValue.isEmpty()) {
            memberSearchValue = memberSearchValue.replaceAll("[%*]", "");
            this.getUiDocumentService().loadRoleMembersBasedOnSearch(roleDocumentForm.getRoleDocument(), memberSearchValue);
        } else {
            this.clear(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        roleDocumentForm.setMemberSearchValue("");
        this.getUiDocumentService().clearRestrictedRoleMembersSearchResults(roleDocumentForm.getRoleDocument());
        KualiTableRenderFormMetadata memberTableMetadata = roleDocumentForm.getMemberTableMetadata();
        if (roleDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToFirstPage(roleDocumentForm.getMemberRows().size(), roleDocumentForm.getRecordsPerPage());
        }
        return mapping.findForward("basic");
    }
}

