/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.repository.type.KewTypeAttribute;
import org.kuali.rice.kew.api.repository.type.KewTypeAttributeContract;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinitionContract;
import org.kuali.rice.kew.api.repository.type.KewTypeRepositoryService;
import org.kuali.rice.kew.impl.type.KewTypeAttributeBo;
import org.kuali.rice.kew.impl.type.KewTypeBo;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public final class KewTypeBoServiceImpl
implements KewTypeRepositoryService {
    private DataObjectService dataObjectService;

    public KewTypeDefinition createKewType(KewTypeDefinition kewType) {
        String namespaceKey;
        if (kewType == null) {
            throw new RiceIllegalArgumentException("kewType is null");
        }
        String nameKey = kewType.getName();
        KewTypeDefinition existing = this.getTypeByNameAndNamespace(nameKey, namespaceKey = kewType.getNamespace());
        if (existing != null && existing.getName().equals(nameKey) && existing.getNamespace().equals(namespaceKey)) {
            throw new RiceIllegalStateException("The KEW Type to create already exists: " + kewType);
        }
        KewTypeBo bo = (KewTypeBo)this.dataObjectService.save((Object)KewTypeBo.from((KewTypeDefinition)kewType), new PersistenceOption[0]);
        return KewTypeBo.to((KewTypeBo)bo);
    }

    public void updateKewType(KewTypeDefinition kewType) {
        KewTypeDefinition toUpdate;
        if (kewType == null) {
            throw new RiceIllegalArgumentException("kewType is null");
        }
        String idKey = kewType.getId();
        KewTypeBo existing = (KewTypeBo)this.dataObjectService.find(KewTypeBo.class, (Object)idKey);
        if (existing == null) {
            throw new RiceIllegalStateException("The KEW type does not exist: " + kewType);
        }
        if (!existing.getId().equals(kewType.getId())) {
            KewTypeDefinition.Builder builder = KewTypeDefinition.Builder.create((KewTypeDefinitionContract)kewType);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = kewType;
        }
        this.dataObjectService.save((Object)KewTypeBo.from((KewTypeDefinition)toUpdate), new PersistenceOption[0]);
    }

    public KewTypeDefinition getTypeById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id is blank");
        }
        KewTypeBo kewTypeBo = (KewTypeBo)this.dataObjectService.find(KewTypeBo.class, (Object)id);
        return KewTypeBo.to((KewTypeBo)kewTypeBo);
    }

    public KewTypeDefinition getTypeByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace is blank");
        }
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)name), PredicateFactory.equal((String)"namespace", (Object)namespace)});
        List myTypes = this.dataObjectService.findMatching(KewTypeBo.class, criteria.build()).getResults();
        if (myTypes.isEmpty()) {
            return null;
        }
        if (myTypes.size() == 1) {
            return KewTypeBo.to((KewTypeBo)((KewTypeBo)myTypes.get(0)));
        }
        throw new RiceIllegalStateException("More than one type found for the given name and namespace - (name=" + name + ", namespace=" + namespace + ").");
    }

    public List<KewTypeDefinition> findAllTypesByNamespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace is blank");
        }
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"namespace", (Object)namespace), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)});
        List kewTypeBos = this.dataObjectService.findMatching(KewTypeBo.class, criteria.build()).getResults();
        return this.convertListOfBosToImmutables(kewTypeBos);
    }

    public List<KewTypeDefinition> findAllTypes() {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)});
        List kewTypeBos = this.dataObjectService.findMatching(KewTypeBo.class, criteria.build()).getResults();
        return this.convertListOfBosToImmutables(kewTypeBos);
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    List<KewTypeDefinition> convertListOfBosToImmutables(Collection<KewTypeBo> kewTypeBos) {
        ArrayList<KewTypeDefinition> kewTypes = new ArrayList<KewTypeDefinition>();
        for (KewTypeBo bo : kewTypeBos) {
            KewTypeDefinition kewType = KewTypeBo.to((KewTypeBo)bo);
            kewTypes.add(kewType);
        }
        return Collections.unmodifiableList(kewTypes);
    }

    public void createKewTypeAttribute(KewTypeAttribute kewTypeAttribute) {
        if (kewTypeAttribute == null) {
            throw new RiceIllegalArgumentException("kewTypeAttribute is null");
        }
        KewTypeAttributeBo existing = (KewTypeAttributeBo)this.dataObjectService.find(KewTypeAttributeBo.class, (Object)kewTypeAttribute.getId());
        if (null != existing && kewTypeAttribute.getTypeId().equals(existing.getTypeId()) && kewTypeAttribute.getAttributeDefinitionId().equals(existing.getAttributeDefinitionId())) {
            throw new RiceIllegalStateException("The KEW Type Attribute to create already exists: " + kewTypeAttribute);
        }
        KewTypeBo kewType = null;
        if (kewTypeAttribute.getTypeId() != null) {
            kewType = (KewTypeBo)this.dataObjectService.find(KewTypeBo.class, (Object)kewTypeAttribute.getTypeId());
        }
        this.dataObjectService.save((Object)KewTypeAttributeBo.from((KewTypeAttribute)kewTypeAttribute, kewType), new PersistenceOption[0]);
    }

    public void updateKewTypeAttribute(KewTypeAttribute kewTypeAttribute) {
        KewTypeAttribute toUpdate;
        if (kewTypeAttribute == null) {
            throw new RiceIllegalArgumentException("kewTypeAttribute is null");
        }
        KewTypeAttributeBo existing = (KewTypeAttributeBo)this.dataObjectService.find(KewTypeAttributeBo.class, (Object)kewTypeAttribute.getId());
        if (existing == null) {
            throw new RiceIllegalStateException("The KEW type Attribute does not exist: " + kewTypeAttribute);
        }
        if (!existing.getId().equals(kewTypeAttribute.getId())) {
            KewTypeAttribute.Builder builder = KewTypeAttribute.Builder.create((KewTypeAttributeContract)kewTypeAttribute);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = kewTypeAttribute;
        }
        KewTypeBo kewType = existing.getType();
        if (!existing.getTypeId().equals(kewTypeAttribute.getTypeId())) {
            kewType = (KewTypeBo)this.dataObjectService.find(KewTypeBo.class, (Object)kewTypeAttribute.getTypeId());
        }
        this.dataObjectService.save((Object)KewTypeAttributeBo.from((KewTypeAttribute)toUpdate, (KewTypeBo)kewType), new PersistenceOption[0]);
    }
}

