/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.bo;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * Simple BO base class that implements Lockable interface 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@MappedSuperclass
public class BaseLockable implements Lockable {
    /**
     * Field names
     */
    public static final String LOCKED_DATE = "lockedDate";

    @Column(name="LOCKD_DTTM", nullable=true)
    protected Timestamp lockedDate;

    /**
     * @see org.kuali.rice.ken.bo.Lockable#getLockedDate()
     */
    @Override
    public Timestamp getLockedDate() {
        return lockedDate;
    }

    /**
     * @see org.kuali.rice.ken.bo.Lockable#setLockedDate(java.sql.Timestamp)
     */
    @Override
    public void setLockedDate(Timestamp lockedDate) {
        this.lockedDate = lockedDate;
    }
}
