/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.service;

import java.util.Collection;

import org.kuali.rice.kcb.bo.Message;

/**
 * The MessageService class is responsible various functions regarding the 
 * Message records that exist within the system.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface MessageService {
    /**
     * Saves a message
     * @param message a Message
     */
    public Message saveMessage(Message message);
    
    /**
     * Deletes a message
     * @param message a Message
     */
    public void deleteMessage(Message message);

    /**
     * Finds a message by id
     * @param id the message id
     * @return the message object if found
     */
    public Message getMessage(Long id);
    
    /**
     * Finds a message by origin id
     * @param id the origin message id
     * @return the message object if found
     */
    public Message getMessageByOriginId(String originId);

    /**
     * Returns all messages in the system
     * @return all messages in the system
     */
    public Collection<Message> getAllMessages();
}
