/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.service;

import java.util.Collection;
import java.util.HashMap;

import org.kuali.rice.kcb.bo.RecipientDelivererConfig;
import org.kuali.rice.kcb.bo.RecipientPreference;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;

/**
 * Service for accessing user preferences in the KEN system.{@link UserPreference}
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RecipientPreferenceService {
    /**
     * This method will get all  user recipient preferences from the system.
     * @param recipientId
     */
    public HashMap<String, String> getRecipientPreferences(String recipientId);

    /**
     * This method will save a user recipient preferences in the system.
     * @param userid
     * @param prefs a hashmap of key/values
     * @param deliveryTypeName name of deliverer
     */
    public void saveRecipientPreferences(String userid, HashMap<String, String> prefs, MessageDeliverer deliverer) throws ErrorList;
    
    /**
     * This method will get a specific user recipient preferences from the system.
     * @param recipientId
     * @param key
     */
    public RecipientPreference getRecipientPreference(String recipientId, String key);

    /**
     * This method will save a specific user recipient preferences in the system.
     * @param pref the preferences
     */
    public RecipientPreference saveRecipientPreference(RecipientPreference pref);
    
    /**
     * This method will delete a specific user recipient preferences from the system.
     * @param pref the preferences
     */
    public void deleteRecipientPreference(RecipientPreference pref);

    // deliverer configuration
    
    /**
     * This method will remove all user deliverer configuration preferences in the system.
     * @param recipientId the recipient id
     */
    public void removeRecipientDelivererConfigs(String recipientId);
    
    /**
     * This method will save a user deliverer configuration preferences in the system.
     * @param recipientId the recipient id
     * @param delivererName the deliverer name
     * @param channels the channels for which to enable the deliverer
     */
    public void saveRecipientDelivererConfig(String recipientId, String delivererName, String[] channels);

    /**
     * This method will retrieve all of the message deliverer configurations for a given user, associated with a 
     * particular channel.
     * @param recipientId
     * @param channel
     */
    public Collection<RecipientDelivererConfig> getDeliverersForRecipientAndChannel(String recipientId, String channel);
    
    /**
     * This method will retrieve all of the message deliverer configurations for a given user 
     * @param recipientId
     */
    public Collection<RecipientDelivererConfig> getDeliverersForRecipient(String recipientId);
}
