/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.exception;

/**
 * This class represents a delivery exception - when notifications are not properly delivered 
 * to their target audiences.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NotificationMessageDeliveryException extends Exception {
    /**
     * Constructs a NotificationMessageDeliveryException instance.
     */
    public NotificationMessageDeliveryException() {
        super();
    }

    /**
     * Constructs a NotificationMessageDeliveryException instance.
     * @param message
     * @param cause
     */
    public NotificationMessageDeliveryException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a NotificationMessageDeliveryException instance.
     * @param message
     */
    public NotificationMessageDeliveryException(String message) {
        super(message);
    }

    /**
     * Constructs a NotificationMessageDeliveryException instance.
     * @param cause
     */
    public NotificationMessageDeliveryException(Throwable cause) {
        super(cause);
    }
}
