/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.service;

import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;

/**
 * The NotificationAuthorizationService class is responsible for housing permissions and authorization 
 * related services.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NotificationAuthorizationService {
    /**
     * This service method validates that the specified producer has the permissions to send a notification 
     * on for a specific NotificationChannel.
     * @param producer
     * @param channel
     * @return boolean - true if authorized, false if not
     */
    public boolean isProducerAuthorizedToSendNotificationForChannel(NotificationProducerBo producer, NotificationChannelBo channel);
    
    /**
     * This method checks to see if the user is authorized as an administrator in the system.
     * @param userId
     * @return boolean - true if authorized, false if not
     */
    public boolean isUserAdministrator(String userId);
}
