/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionitem;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * Outbox item.  An extension of {@link ActionItemActionListExtension} for OJB.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
@Entity
@Table(name="KREW_OUT_BOX_ITM_T")
public class OutboxItem extends ActionItemBase {

	private static final long serialVersionUID = 5776214610837858304L;

	public OutboxItem() {}

	public OutboxItem(ActionItem actionItem) {
		this.setActionRequestCd(actionItem.getActionRequestCd());
		this.setActionRequestId(actionItem.getActionRequestId());
		this.setDateAssigned(actionItem.getDateAssigned());
		this.setDelegationType(actionItem.getDelegationType());
		this.setDelegatorPrincipalId(actionItem.getDelegatorPrincipalId());
		this.setDelegatorGroupId(actionItem.getDelegatorGroupId());
		this.setDocHandlerURL(actionItem.getDocHandlerURL());
		this.setDocLabel(actionItem.getDocLabel());
		this.setDocName(actionItem.getDocName());
		this.setDocTitle(actionItem.getDocTitle());
		this.setResponsibilityId(actionItem.getResponsibilityId());
		this.setRoleName(actionItem.getRoleName());
		this.setDocumentId(actionItem.getDocumentId());
		this.setPrincipalId(actionItem.getPrincipalId());
		this.setGroupId(actionItem.getGroupId());
		this.setRequestLabel(actionItem.getRequestLabel());
	}

}
