/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.doctype;

import org.kuali.rice.krad.data.jpa.IdClassBase;

/**
 * Compound primary key for {@link DocumentTypePolicy}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentTypePolicyId extends IdClassBase {

    private static final long serialVersionUID = -8024479878884387727L;

    private String documentType;
    private String policyName;

    public DocumentTypePolicyId() {}

    public DocumentTypePolicyId(String documentType, String policyName) {
        this.documentType = documentType;
        this.policyName = policyName;
    }

    public String getDocumentType() {
        return documentType;
    }

    public String getPolicyName() {
        return policyName;
    }

}

