/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.doctype.bo;

import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public interface DocumentTypeEBO extends ExternalizableBusinessObject{

	public String getDocTypeParentId();

	public String getDescription();

	/**
	 * This method gets the help definition url from this object and resolves any
	 * potential variables that may be in use
	 */
	public String getHelpDefinitionUrl();

	public String getLabel();

	public String getName();

	public String getDocumentTypeId();

	/**
	 * Returns the application id for this DocumentType which can be specified on the document type itself,
	 * inherited from the parent, or defaults to the configured application id of the application.
	 *
	 * chb:12Nov2008: seems like the accessor should return the field and the auxiliary method "getActualFoo" should
	 * be the one to do more elaborate checking
	 */
	public String getApplicationId();

	/**
	 * In order to make this object Inactivateable. Not sure if I
	 * should remove the getActive method.
	 *
	 * @see org.kuali.rice.core.api.mo.common.active.MutableInactivatable#isActive()
	 */
	public boolean isActive();

}
