/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.doctype.service;

import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kim.api.permission.Permission;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;


/**
 * Service for data access of document types.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DocumentTypeService extends DocumentTypeQueryService, XmlExporter {
    @CacheEvict(value={Rule.Cache.NAME, org.kuali.rice.kew.api.doctype.DocumentType.Cache.NAME, Permission.Cache.NAME}, allEntries = true)
    DocumentType versionAndSave(DocumentType documentType);

    @CacheEvict(value={Rule.Cache.NAME, org.kuali.rice.kew.api.doctype.DocumentType.Cache.NAME, Permission.Cache.NAME}, allEntries = true)
    DocumentType save(DocumentType documentType);

    @Cacheable(value= org.kuali.rice.kew.api.doctype.DocumentType.Cache.NAME, key="'{BO}allCurrentRootDocuments'")
    List<DocumentType> findAllCurrentRootDocuments();

    @Cacheable(value= org.kuali.rice.kew.api.doctype.DocumentType.Cache.NAME, key="'{BO}allCurrent'")
    List<DocumentType> findAllCurrent();

    @Cacheable(value= org.kuali.rice.kew.api.doctype.DocumentType.Cache.NAME, key="'{BO}{previousInstances}' + 'documentTypeName=' + #p0")
    List<DocumentType> findPreviousInstances(String documentTypeName);

    @Cacheable(value= org.kuali.rice.kew.api.doctype.DocumentType.Cache.NAME, key="'{BO}{childDocumentTypes}' + 'documentTypeId=' + #p0")
    List<DocumentType> getChildDocumentTypes(String documentTypeId);

    /**
     *
     * This method is similar to the findByName method except it is case insensitive.
     *
     * @param name
     * @return
     */
    DocumentType findByNameCaseInsensitive(String name);
}
