/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.lifecycle;

import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.kew.batch.XmlPollerService;
import org.kuali.rice.kew.service.KEWServiceLocator;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class XmlPipelineLifeCycle extends BaseLifecycle {

	protected final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(XmlPipelineLifeCycle.class);

	private ScheduledExecutorService scheduledExecutor;
	private ScheduledFuture future;

	@Override
    public void start() throws Exception {
		LOG.info("Configuring XML ingestion pipeline...");
		scheduledExecutor = Executors.newScheduledThreadPool(1);
		final XmlPollerService xmlPoller = KEWServiceLocator.getXmlPollerService();
		LOG.info("Starting XML data loader.  Polling at " + xmlPoller.getPollIntervalSecs() + "-second intervals");
		if (!ConfigContext.getCurrentContextConfig().getDevMode()) {
			future = scheduledExecutor.scheduleWithFixedDelay(xmlPoller, xmlPoller.getInitialDelaySecs(), xmlPoller.getPollIntervalSecs(), TimeUnit.SECONDS);
			super.start();
		}
	}

	@Override
    public void stop() throws Exception {
		if (isStarted()) {
			LOG.warn("Shutting down XML file polling timer");
			try {
				if (future != null) {
					if (!future.cancel(false)) {
						LOG.warn("Failed to cancel the XML Poller service.");
					}
					future = null;
				}
				if (scheduledExecutor != null) {
					scheduledExecutor.shutdownNow();
					scheduledExecutor = null;
				}
			} finally {
				super.stop();
			}
		}
	}

}
