/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.lookup.valuefinder;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.util.GlobalVariables;

import java.util.ArrayList;
import java.util.List;

public class SavedSearchValuesFinder extends KeyValuesBase {

	@Override
	public List<KeyValue> getKeyValues() {
		List<KeyValue> savedSearchValues = new ArrayList<KeyValue>();
		savedSearchValues.add(new ConcreteKeyValue("", "Searches"));
		savedSearchValues.add(new ConcreteKeyValue("*ignore*", "-----"));
		savedSearchValues.add(new ConcreteKeyValue("*ignore*", "-Named Searches"));
		List<KeyValue> namedSearches = KEWServiceLocator.getDocumentSearchService().getNamedSearches(GlobalVariables.getUserSession().getPrincipalId());
		for (KeyValue keyValue : namedSearches) {
			String label = StringUtils.abbreviate(keyValue.getValue(), 75);
			KeyValue keyLabel = new ConcreteKeyValue(keyValue.getKey(),label);
			savedSearchValues.add(keyLabel);
		}
		savedSearchValues.add(new ConcreteKeyValue("*ignore*", "-----"));
		savedSearchValues.add(new ConcreteKeyValue("*ignore*", "-Recent Searches"));
		List<KeyValue> mostRecentSearches = KEWServiceLocator.getDocumentSearchService().getMostRecentSearches(GlobalVariables.getUserSession().getPrincipalId());
		for (KeyValue keyValue : mostRecentSearches) {
			String label = StringUtils.abbreviate(keyValue.getValue(), 75);
			KeyValue keyLabel = new ConcreteKeyValue(keyValue.getKey(),label);
			savedSearchValues.add(keyLabel);
		}
		return savedSearchValues;
	}

}
